/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.PriorityQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DelayQueue
extends AbstractQueue
implements BlockingQueue {
    private final transient ReentrantLock lock;
    private final transient Condition available;
    private final PriorityQueue q;
    private static final /* synthetic */ boolean assert;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            this.q.offer(o);
            if (first == null || ((Delayed)o).compareTo(first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            Object var4_5 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void put(Object o) {
        this.offer(o);
    }

    public boolean offer(Object o, long timeout, TimeUnit unit) {
        return this.offer(o);
    }

    public boolean add(Object o) {
        return this.offer(o);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay <= 0L) break;
                this.available.await(delay, TimeUnit.NANOSECONDS);
            }
            Object x = this.q.poll();
            if (!assert && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Object object = x;
            Object var3_6 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object object;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        long nanos = unit.toNanos(timeout);
        try {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        Object var9_8 = null;
                        Object var8_10 = null;
                        lock.unlock();
                        return var9_8;
                    }
                    this.available.await(nanos, TimeUnit.NANOSECONDS);
                    nanos = deadline - Utils.nanoTime();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay <= 0L) break;
                if (delay > nanos) {
                    delay = nanos;
                }
                this.available.await(delay, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
            Object x = this.q.poll();
            if (!assert && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            object = x;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            lock.unlock();
            throw throwable;
        }
        Object var8_11 = null;
        lock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        ReentrantLock lock;
        block5: {
            lock = this.lock;
            lock.lock();
            try {
                Object first = this.q.peek();
                if (first != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L) break block5;
                Object var4_3 = null;
                Object var3_5 = null;
                lock.unlock();
                return var4_3;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                lock.unlock();
                throw throwable;
            }
        }
        Object x = this.q.poll();
        if (!assert && x == null) {
            throw new AssertionError();
        }
        if (this.q.size() != 0) {
            this.available.signalAll();
        }
        Object object = x;
        Object var3_6 = null;
        lock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.peek();
            Object var3_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            Object var3_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n = 0;
            while ((first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var4_6 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = 0;
            while (n < maxElements) {
                Object first = this.q.peek();
                if (first == null || ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) > 0L) break;
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var5_7 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            lock.unlock();
            return;
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var3_3 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(array);
            Object var4_4 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            Object var4_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr(this.q.iterator());
            Object var3_3 = null;
            lock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new ReentrantLock();
        this.available = this.lock.newCondition();
        this.q = new PriorityQueue();
    }

    public DelayQueue() {
        this.this();
    }

    public DelayQueue(Collection c) {
        this.this();
        this.addAll(c);
    }

    static {
        assert = Class.forName("[Ledu.emory.mathcs.backport.java.util.concurrent.DelayQueue;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        private final Iterator iter;

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ReentrantLock lock = DelayQueue.this.lock;
            lock.lock();
            try {
                Object e = this.iter.next();
                Object var3_3 = null;
                lock.unlock();
                return e;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void remove() {
            ReentrantLock lock = DelayQueue.this.lock;
            lock.lock();
            try {
                this.iter.remove();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lock.unlock();
                throw throwable;
            }
            {
                Object var3_4 = null;
                lock.unlock();
                return;
            }
        }

        Itr(Iterator i) {
            this.iter = i;
        }
    }
}

