/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.unit;

import java.sql.DatabaseMetaData;
import java.util.List;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.FieldAnnotationReaderFactory;
import org.seasar.dao.impl.ValueTypeFactoryImpl;
import org.seasar.dao.unit.S2DaoBeanListReader;
import org.seasar.dao.unit.S2DaoBeanReader;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.unit.S2TestCase;

public abstract class S2DaoTestCase
extends S2TestCase {
    private ValueTypeFactory valueTypeFactory;
    private AnnotationReaderFactory annotationReaderFactory;

    public S2DaoTestCase() {
    }

    public S2DaoTestCase(String name) {
        super(name);
    }

    protected void assertBeanEquals(String message, DataSet expected, Object bean) {
        S2DaoBeanReader reader = new S2DaoBeanReader(bean, this.createBeanMetaData(bean.getClass()));
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanListEquals(String message, DataSet expected, List list) {
        S2DaoBeanListReader reader = new S2DaoBeanListReader(list, this.createBeanMetaData(list.get(0).getClass()));
        this.assertEquals(message, expected, reader.read());
    }

    protected Dbms getDbms() {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        return DbmsManager.getDbms(dbMetaData);
    }

    protected BeanMetaData createBeanMetaData(Class beanClass) {
        BeanMetaDataImpl beanMetaData = new BeanMetaDataImpl();
        beanMetaData.setBeanClass(beanClass);
        beanMetaData.setDatabaseMetaData(this.getDatabaseMetaData());
        beanMetaData.setDbms(this.getDbms());
        beanMetaData.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
        beanMetaData.setValueTypeFactory(this.getValueTypeFactory());
        beanMetaData.initialize();
        return beanMetaData;
    }

    protected ValueTypeFactory getValueTypeFactory() {
        if (this.valueTypeFactory == null) {
            ValueTypeFactoryImpl v = new ValueTypeFactoryImpl();
            v.setContainer(this.getContainer());
            this.valueTypeFactory = v;
        }
        return this.valueTypeFactory;
    }

    protected AnnotationReaderFactory getAnnotationReaderFactory() {
        if (this.annotationReaderFactory == null) {
            this.annotationReaderFactory = new FieldAnnotationReaderFactory();
        }
        return this.annotationReaderFactory;
    }

    protected void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    protected void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    protected DaoMetaDataImpl createDaoMetaData(Class daoClass) {
        DaoMetaDataImpl daoMetaData = new DaoMetaDataImpl();
        daoMetaData.setDaoClass(daoClass);
        daoMetaData.setDataSource(this.getDataSource());
        daoMetaData.setStatementFactory(BasicStatementFactory.INSTANCE);
        daoMetaData.setResultSetFactory(BasicResultSetFactory.INSTANCE);
        daoMetaData.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
        daoMetaData.setValueTypeFactory(this.getValueTypeFactory());
        daoMetaData.initialize();
        return daoMetaData;
    }
}

