/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;

class StrutsUtils {
    StrutsUtils() {
    }

    static DataSource getDataSource(ServletContext application) {
        if (application == null) {
            return null;
        }
        return (DataSource)application.getAttribute("org.apache.struts.action.DATA_SOURCE");
    }

    static ActionFormBeans getActionFormBeans(ServletContext application) {
        if (application == null) {
            return null;
        }
        return (ActionFormBeans)application.getAttribute("org.apache.struts.action.FORM_BEANS");
    }

    static ActionFormBean getFormBean(String name, ServletContext application) {
        ActionFormBeans formBeans = StrutsUtils.getActionFormBeans(application);
        if (formBeans == null) {
            return null;
        }
        return formBeans.findFormBean(name);
    }

    static ActionForwards getActionForwards(ServletContext application) {
        if (application == null) {
            return null;
        }
        return (ActionForwards)application.getAttribute("org.apache.struts.action.FORWARDS");
    }

    static ActionForward getActionForward(String name, ServletContext application) {
        ActionForwards forwards = StrutsUtils.getActionForwards(application);
        if (forwards == null) {
            return null;
        }
        return forwards.findForward(name);
    }

    static ActionMappings getActionMappings(ServletContext application) {
        if (application == null) {
            return null;
        }
        return (ActionMappings)application.getAttribute("org.apache.struts.action.MAPPINGS");
    }

    static ActionMapping getActionMapping(String path, ServletContext application) {
        ActionMappings mappings = StrutsUtils.getActionMappings(application);
        if (mappings == null) {
            return null;
        }
        return mappings.findMapping(path);
    }

    static MessageResources getMessageResources(ServletContext application) {
        if (application == null) {
            return null;
        }
        return (MessageResources)application.getAttribute("org.apache.struts.action.MESSAGE");
    }

    static String getServletMapping(ServletContext application) {
        if (application == null) {
            return null;
        }
        return (String)application.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    static Locale getLocale(HttpServletRequest request, HttpSession session) {
        Locale locale = null;
        if (session != null) {
            locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null && request != null) {
            locale = request.getLocale();
        }
        return locale;
    }

    static String getToken(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("org.apache.struts.action.TOKEN");
    }

    static ActionErrors getActionErrors(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
    }

    static Throwable getException(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (Throwable)request.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    static MultipartRequestWrapper getMultipartRequestWrapper(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (MultipartRequestWrapper)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    static ActionMapping getMapping(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
    }

    static ActionForm getActionForm(HttpServletRequest request, HttpSession session) {
        ActionMapping mapping = (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
        if (mapping == null) {
            return null;
        }
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        if ("request".equals(mapping.getScope())) {
            return (ActionForm)request.getAttribute(attribute);
        }
        if (session != null) {
            return (ActionForm)session.getAttribute(attribute);
        }
        return null;
    }

    static String getCancelName() {
        return "org.apache.struts.taglib.html.CANCEL";
    }

    static String getGlobalErrorName() {
        return "org.apache.struts.action.GLOBAL_ERROR";
    }

    static String getTokenName() {
        return "org.apache.struts.taglib.html.TOKEN";
    }

    static String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        if (value.startsWith("/")) {
            return value;
        }
        return "/" + value;
    }

    static String getActionMappingURL(ServletContext application, HttpServletRequest request, String action) {
        StringBuffer value = new StringBuffer(request.getContextPath());
        String servletMapping = StrutsUtils.getServletMapping(application);
        if (servletMapping != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = StrutsUtils.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    static String errorMarkup(String property, HttpServletRequest request, HttpSession session, ServletContext application) {
        ActionErrors errors = StrutsUtils.getActionErrors(request);
        if (errors == null) {
            return "";
        }
        Iterator reports = null;
        reports = property == null ? errors.get() : errors.get(property);
        if (!reports.hasNext()) {
            return "";
        }
        StringBuffer results = new StringBuffer();
        String header = null;
        String footer = null;
        Locale locale = StrutsUtils.getLocale(request, session);
        MessageResources resources = StrutsUtils.getMessageResources(application);
        if (resources != null) {
            header = resources.getMessage(locale, "errors.header");
            footer = resources.getMessage(locale, "errors.footer");
        }
        if (header == null) {
            header = "errors.header";
        }
        if (footer == null) {
            footer = "errors.footer";
        }
        results.append(header);
        results.append("\r\n");
        while (reports.hasNext()) {
            String message = null;
            ActionError report = (ActionError)reports.next();
            if (resources != null) {
                message = resources.getMessage(locale, report.getKey(), report.getValues());
            }
            if (message != null) {
                results.append(message);
                results.append("\r\n");
                continue;
            }
            results.append(report.getKey());
            results.append("\r\n");
        }
        results.append(footer);
        results.append("\r\n");
        return results.toString();
    }
}

