/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jimx.compdh;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataReferencer;
import jp.gr.javacons.jim.DataReferencerOwner;
import jp.gr.javacons.jim.DataReferencerStatusMonitor;
import jp.gr.javacons.jim.DataValueChangeEvent;
import jp.gr.javacons.jim.DataValueChangeListener;
import jp.gr.javacons.jimx.compdh.ComposingEngine;
import jp.gr.javacons.jimx.compdh.CompositeValue;
import jp.gr.javacons.jimx.compdh.DataReferencerContainer;

public class EventComposer
implements DataReferencerOwner,
DataReferencerStatusMonitor,
Serializable {
    private static final long serialVersionUID = 8353309309044288654L;
    private transient CompositeValue value = null;
    private Hashtable adapters;
    private DataReferencerContainer container;
    private ComposingEngine engine;
    private Hashtable eventFlags = new Hashtable();
    private static final Class[][] DH_TYPE_INFO = new Class[][]{{DataHolder.class, Object.class}};

    public EventComposer() {
        this.adapters = new Hashtable();
        this.value = new CompositeValue();
        this.engine = new ComposingEngine();
    }

    protected void setContainer(DataReferencerContainer container) {
        this.container = container;
        container.setValue(this.value, new Date(), null);
    }

    protected void setComposingEngine(ComposingEngine engine) {
        this.engine = engine;
        this.resetEventFlags();
        engine.setFlags(this.eventFlags);
    }

    protected ComposingEngine getComposingEngine() {
        return this.engine;
    }

    public void dataReferencerConnected(DataReferencer dr, DataHolder dh, boolean flag) {
        if (flag) {
            this.container.memberConnected(dh, dr);
            this.registerDataListeners(dh, dr);
        } else {
            this.unregisterDataListeners(dh, dr);
            this.container.memberDisconnected(dh, dr);
        }
    }

    private void registerDataListeners(DataHolder dh, DataReferencer dr) {
        DataValueChangeListener listener = (DataValueChangeListener)this.adapters.get(dr);
        if (listener == null) {
            listener = new DataValueChangeAdapter(dr);
            this.adapters.put(dr, listener);
        }
        dh.addDataValueChangeListener(listener);
        this.eventFlags.put(dr, Boolean.FALSE);
        this.resetEventFlags();
    }

    private void unregisterDataListeners(DataHolder dh, DataReferencer dr) {
        DataValueChangeListener listener = (DataValueChangeListener)this.adapters.get(dr);
        dh.removeDataValueChangeListener(listener);
        this.adapters.remove(dr);
        this.eventFlags.remove(dr);
        this.resetEventFlags();
    }

    public Class[][] getReferableDataHolderTypeInfo(DataReferencer dataRef) {
        return DH_TYPE_INFO;
    }

    protected void addMember(DataReferencer ref) {
        ref.connect(this);
        this.value.addMember(ref.getDataHolder());
    }

    protected void removeMember(DataReferencer ref) {
        this.value.removeMember(ref.getDataHolder());
        ref.disconnect(this);
    }

    protected void resetEventFlags() {
        Enumeration e = this.eventFlags.keys();
        while (e.hasMoreElements()) {
            this.eventFlags.put(e.nextElement(), Boolean.FALSE);
        }
    }

    private void composeEvent(DataReferencer ref, DataValueChangeEvent event) {
        if (this.value == null) {
            this.makeValue();
        }
        this.value.setValue(ref.getDataHolder(), event.getValue(), event.getTimeStamp(), event.getQualityFlag());
        this.eventFlags.put(ref, Boolean.TRUE);
        if (this.engine.compose()) {
            this.container.setValue(this.value, new Date(), this.container.getQualityFlag());
            this.resetEventFlags();
        }
    }

    private void makeValue() {
        this.value = new CompositeValue();
        Enumeration e = this.container.getMembers();
        while (e.hasMoreElements()) {
            DataReferencer ref = (DataReferencer)e.nextElement();
            this.value.addMember(ref.getDataHolder());
        }
    }

    private class DataValueChangeAdapter
    implements DataValueChangeListener,
    Serializable {
        private static final long serialVersionUID = -5486725933540734766L;
        private DataReferencer referencer;

        public DataValueChangeAdapter(DataReferencer referencer) {
            this.referencer = referencer;
        }

        public void dataValueChanged(DataValueChangeEvent event) {
            EventComposer.this.composeEvent(this.referencer, event);
        }
    }
}

