/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataProviderDoesNotSupportException;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jim.Utility;

class DataHolderCreateEditor
extends Dialog {
    private static final long serialVersionUID = 4390183164853040692L;
    private TextField dataHolderNameField;
    private Choice dataHolderTypeChoice;
    private DataProvider dataProvider;
    private Class[][] dataHolderTypeInfo;
    private DataHolder dataHolder = null;
    static ResourceBundle res = ResourceBundle.getBundle("jp.gr.javacons.jim.DataProviderCustomizerResBundle", Locale.getDefault());

    public DataHolderCreateEditor(Frame parent, DataProvider dataProvider, Class[][] dataHolderTypeInfo) {
        super(parent, res.getString("createdh"), true);
        this.dataProvider = dataProvider;
        this.dataHolderTypeInfo = dataHolderTypeInfo;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DataHolderCreateEditor.this.doCancel();
            }
        });
        this.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        Label l = new Label(res.getString("dp"));
        gbl.setConstraints(l, c);
        this.add(l);
        c.weightx = 1.0;
        c.gridwidth = 0;
        l = new Label(dataProvider.getDataProviderName());
        gbl.setConstraints(l, c);
        this.add(l);
        c.weightx = 0.0;
        c.gridwidth = 1;
        l = new Label(res.getString("dhn"));
        gbl.setConstraints(l, c);
        this.add(l);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.dataHolderNameField = new TextField(30);
        gbl.setConstraints(this.dataHolderNameField, c);
        this.add(this.dataHolderNameField);
        c.gridwidth = 1;
        l = new Label(res.getString("dht"));
        gbl.setConstraints(l, c);
        this.add(l);
        c.gridwidth = 0;
        this.dataHolderTypeChoice = new Choice();
        gbl.setConstraints(this.dataHolderTypeChoice, c);
        this.add(this.dataHolderTypeChoice);
        c.weighty = 0.0;
        Panel p = new Panel(new FlowLayout(1, 20, 5));
        Button b = new Button(res.getString("OK"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataHolderCreateEditor.this.doOK();
            }
        });
        p.add(b);
        b = new Button(res.getString("Cancel"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataHolderCreateEditor.this.doCancel();
            }
        });
        p.add(b);
        gbl.setConstraints(p, c);
        this.add(p);
        for (int i = 0; i < dataHolderTypeInfo.length; ++i) {
            Class[] dhi = dataHolderTypeInfo[i];
            this.dataHolderTypeChoice.add(this.getTypeString(dhi[0], dhi[1]));
        }
        this.pack();
    }

    private void doCancel() {
        this.dataHolder = null;
        this.setVisible(false);
    }

    private void doOK() {
        Frame parent = (Frame)this.getParent();
        String dhName = this.dataHolderNameField.getText();
        if ("".equals(dhName)) {
            Utility.showMessage(parent, res.getString("input_dhn"));
            return;
        }
        int index = this.dataHolderTypeChoice.getSelectedIndex();
        Class[] dti = this.dataHolderTypeInfo[index];
        try {
            this.dataHolder = (DataHolder)dti[0].newInstance();
        }
        catch (IllegalAccessException ex) {
            Utility.showMessage(parent, ex.getMessage());
            return;
        }
        catch (InstantiationException ex) {
            Utility.showMessage(parent, ex.getMessage());
            return;
        }
        this.dataHolder.setValueClass(dti[1]);
        this.dataHolder.setDataHolderName(this.dataHolderNameField.getText());
        try {
            this.dataProvider.addDataHolder(this.dataHolder);
        }
        catch (DataProviderDoesNotSupportException ex) {
            Utility.showMessage(parent, res.getString("cannot_add_dh"));
            return;
        }
        catch (IllegalArgumentException ex) {
            Utility.showMessage(parent, ex.getMessage());
            return;
        }
        this.setVisible(false);
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    private String getTypeString(Class dataHolderClass, Class valueClass) {
        String tStr = this.dataProvider.getDataHolderTypeString(dataHolderClass, valueClass);
        if (tStr == null) {
            tStr = Manager.getInstance().getDefaultDataHolderTypeString(dataHolderClass, valueClass);
        }
        return tStr;
    }
}

