/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.NodeFilter;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.rule.Pattern;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultDocumentType;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultEntity;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.dom4j.tree.DefaultText;
import org.dom4j.tree.QNameCache;
import org.dom4j.xpath.DefaultXPath;
import org.dom4j.xpath.XPathPattern;
import org.jaxen.VariableContext;

public class DocumentFactory
implements Serializable {
    private static transient DocumentFactory singleton;
    protected transient QNameCache cache;
    static /* synthetic */ Class class$org$dom4j$DocumentFactory;

    static {
        String className = null;
        try {
            className = System.getProperty("org.dom4j.factory", "org.dom4j.DocumentFactory");
        }
        catch (Exception exception) {
            className = "org.dom4j.DocumentFactory";
        }
        singleton = DocumentFactory.createSingleton(className);
    }

    public DocumentFactory() {
        this.init();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Attribute createAttribute(Element owner, String name, String value) {
        return this.createAttribute(owner, this.createQName(name), value);
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        return new DefaultAttribute(qname, value);
    }

    public CDATA createCDATA(String text) {
        return new DefaultCDATA(text);
    }

    public Comment createComment(String text) {
        return new DefaultComment(text);
    }

    public DocumentType createDocType(String name, String publicId, String systemId) {
        return new DefaultDocumentType(name, publicId, systemId);
    }

    public Document createDocument() {
        DefaultDocument answer = new DefaultDocument();
        answer.setDocumentFactory(this);
        return answer;
    }

    public Document createDocument(Element rootElement) {
        Document answer = this.createDocument();
        answer.setRootElement(rootElement);
        return answer;
    }

    public Element createElement(String name) {
        return this.createElement(this.createQName(name));
    }

    public Element createElement(String qualifiedName, String namespaceURI) {
        return this.createElement(this.createQName(qualifiedName, namespaceURI));
    }

    public Element createElement(QName qname) {
        return new DefaultElement(qname);
    }

    public Entity createEntity(String name, String text) {
        return new DefaultEntity(name, text);
    }

    public Namespace createNamespace(String prefix, String uri) {
        return Namespace.get(prefix, uri);
    }

    public Pattern createPattern(String xpathPattern) {
        return new XPathPattern(xpathPattern);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public QName createQName(String localName) {
        return this.cache.get(localName);
    }

    public QName createQName(String qualifiedName, String uri) {
        return this.cache.get(qualifiedName, uri);
    }

    public QName createQName(String name, String prefix, String uri) {
        return this.cache.get(name, Namespace.get(prefix, uri));
    }

    public QName createQName(String localName, Namespace namespace) {
        return this.cache.get(localName, namespace);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    protected static DocumentFactory createSingleton(String className) {
        try {
            Class<?> theClass = Class.forName(className, true, (class$org$dom4j$DocumentFactory != null ? class$org$dom4j$DocumentFactory : (class$org$dom4j$DocumentFactory = DocumentFactory.class$("org.dom4j.DocumentFactory"))).getClassLoader());
            return (DocumentFactory)theClass.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + className);
            return new DocumentFactory();
        }
    }

    public Text createText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Adding text to an XML document must not be null");
        }
        return new DefaultText(text);
    }

    public XPath createXPath(String xpathExpression) throws InvalidXPathException {
        return new DefaultXPath(xpathExpression);
    }

    public XPath createXPath(String xpathExpression, VariableContext variableContext) {
        XPath xpath = this.createXPath(xpathExpression);
        xpath.setVariableContext(variableContext);
        return xpath;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression) {
        return new DefaultXPath(xpathFilterExpression);
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression, VariableContext variableContext) {
        DefaultXPath answer = new DefaultXPath(xpathFilterExpression);
        answer.setVariableContext(variableContext);
        return answer;
    }

    public static DocumentFactory getInstance() {
        return singleton;
    }

    public List getQNames() {
        return this.cache.getQNames();
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }

    protected QName intern(QName qname) {
        return this.cache.intern(qname);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

