/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

package org.F11.scada.tool.page.trend.item;

import static org.F11.scada.cat.util.CollectionUtil.list;

import java.rmi.Naming;
import java.util.List;

import org.F11.scada.WifeUtilities;
import org.F11.scada.server.frame.editor.FrameEditHandler;
import org.F11.scada.server.frame.editor.TaskItemDefine;
import org.F11.scada.server.register.HolderString;

public class TaskItemServiceImpl implements TaskItemService {
	private TaskItemDao dao;

	public void setDao(TaskItemDao dao) {
		this.dao = dao;
	}

	public List<TaskItemDefine> getTaskItemDefine(
			String handleName,
			TaskItemCondition condition) throws Exception {
		FrameEditHandler handler =
			(FrameEditHandler) Naming.lookup(WifeUtilities
				.createRmiFrameEditManager());
		List<HolderString> itemList = handler.getHolders(handleName);
		List<String> providers = list();
		List<String> holders = list();
		for (HolderString hs : itemList) {
			String provider = hs.getProvider();
			if (!providers.contains(provider)) {
				providers.add(provider);
			}
			String holder = hs.getHolder();
			if (!holders.contains(holder)) {
				holders.add(holder);
			}
		}
		condition.setProviders(providers);
		condition.setHolders(holders);
		return dao.getAnalogNameList(condition);
	}
}
