/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Collection;

public class ReentrantLock
implements Lock,
Serializable,
CondVar.LockInfo {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Impl impl;

    public void lock() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.impl.lockInterruptibly();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        this.impl.lockInterruptibly();
    }

    public boolean tryLock() {
        return this.impl.tryLock();
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.tryLock(unit.toNanos(timeout));
    }

    public void unlock() {
        this.impl.unlock();
    }

    public Condition newCondition() {
        return new CondVar(this);
    }

    public int getHoldCount() {
        return this.impl.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.impl.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.impl.isLocked();
    }

    public final boolean isFair() {
        return this.impl.isFair();
    }

    protected Thread getOwner() {
        return this.impl.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.impl.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.impl.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.impl.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.impl.getQueuedThreads();
    }

    public String toString() {
        Thread owner = this.getOwner();
        return super.toString() + (owner == null ? "[Unlocked]" : "[Locked by thread " + owner.getName() + ']');
    }

    public ReentrantLock() {
        this.impl = new NonfairImpl();
    }

    public ReentrantLock(boolean fair) {
        this.impl = fair ? new FairImpl() : new NonfairImpl();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class Impl {
        protected Thread owner_;
        protected int holds_;

        public abstract void lockInterruptibly() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean tryLock() {
            Thread caller = Thread.currentThread();
            Impl impl = this;
            synchronized (impl) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return true;
                }
                if (caller == this.owner_) {
                    ++this.holds_;
                    return true;
                }
                return false;
            }
        }

        public abstract boolean tryLock(long var1) throws InterruptedException;

        public abstract void unlock();

        public synchronized int getHoldCount() {
            int n = 0;
            if (this.isHeldByCurrentThread()) {
                n = this.holds_;
            }
            return n;
        }

        public synchronized boolean isHeldByCurrentThread() {
            boolean bl = false;
            if (Thread.currentThread() == this.owner_) {
                bl = true;
            }
            return bl;
        }

        public synchronized boolean isLocked() {
            boolean bl = false;
            if (this.owner_ != null) {
                bl = true;
            }
            return bl;
        }

        public abstract boolean isFair();

        protected synchronized Thread getOwner() {
            return this.owner_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public boolean isQueued(Thread thread) {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        private final /* synthetic */ void this() {
            this.owner_ = null;
            this.holds_ = 0;
        }

        protected Impl() {
            this.this();
        }
    }

    static final class NonfairImpl
    extends Impl
    implements Serializable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            NonfairImpl nonfairImpl = this;
            synchronized (nonfairImpl) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                if (caller == this.owner_) {
                    ++this.holds_;
                    return;
                }
                try {
                    do {
                        this.wait();
                    } while (this.owner_ != null);
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        /*
         * Exception decompiling
         */
        public final boolean tryLock(long nanos) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [11 : 30->176)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public final synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }

        public final boolean isFair() {
            return false;
        }

        NonfairImpl() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class FairImpl
    extends Impl
    implements WaitQueue.QueuedSync,
    Serializable {
        private final WaitQueue wq_;

        public final synchronized boolean recheck(WaitQueue.WaitNode node) {
            Thread caller = Thread.currentThread();
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                return true;
            }
            if (caller == this.owner_) {
                ++this.holds_;
                return true;
            }
            this.wq_.insert(node);
            return false;
        }

        public final synchronized void takeOver(WaitQueue.WaitNode node) {
            this.owner_ = node.getOwner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lockInterruptibly() throws InterruptedException {
            WaitQueue.WaitNode n;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            FairImpl fairImpl = this;
            synchronized (fairImpl) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                if (caller == this.owner_) {
                    ++this.holds_;
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                n = new WaitQueue.WaitNode();
            }
            n.doWait(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean tryLock(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            FairImpl fairImpl = this;
            synchronized (fairImpl) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return true;
                }
                if (caller == this.owner_) {
                    ++this.holds_;
                    return true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                WaitQueue.WaitNode n = new WaitQueue.WaitNode();
                return n.doTimedWait(this, nanos);
            }
        }

        protected final synchronized WaitQueue.WaitNode getSignallee(Thread caller) {
            if (caller != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (this.holds_ >= 2) {
                --this.holds_;
                return null;
            }
            WaitQueue.WaitNode w = this.wq_.extract();
            if (w == null) {
                this.owner_ = null;
                this.holds_ = 0;
            }
            return w;
        }

        public final void unlock() {
            WaitQueue.WaitNode w;
            Thread caller = Thread.currentThread();
            do {
                if ((w = this.getSignallee(caller)) != null) continue;
                return;
            } while (!w.signal(this));
        }

        public final boolean isFair() {
            return true;
        }

        public final synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public final synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public final synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        public final synchronized boolean isQueued(Thread thread) {
            return this.wq_.isWaiting(thread);
        }

        private final /* synthetic */ void this() {
            this.wq_ = new FIFOWaitQueue();
        }

        FairImpl() {
            this.this();
        }
    }
}

