/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.CDATA;
import org.dom4j.Entity;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class HTMLWriter
extends XMLWriter {
    protected static final OutputFormat defaultHtmlFormat = new OutputFormat("  ", true);
    private Set omitElementCloseSet;

    static {
        defaultHtmlFormat.setTrimText(true);
        defaultHtmlFormat.setSuppressDeclaration(true);
    }

    public HTMLWriter() throws UnsupportedEncodingException {
        super(defaultHtmlFormat);
    }

    public HTMLWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out, defaultHtmlFormat);
    }

    public HTMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        super(out, format);
    }

    public HTMLWriter(Writer writer) {
        super(writer, defaultHtmlFormat);
    }

    public HTMLWriter(Writer writer, OutputFormat format) {
        super(writer, format);
    }

    public HTMLWriter(OutputFormat format) throws UnsupportedEncodingException {
        super(format);
    }

    public void endCDATA() throws SAXException {
    }

    protected Set getOmitElementCloseSet() {
        if (this.omitElementCloseSet == null) {
            this.omitElementCloseSet = new HashSet();
            this.loadOmitElementCloseSet(this.omitElementCloseSet);
        }
        return this.omitElementCloseSet;
    }

    protected String getPadText() {
        return " ";
    }

    protected boolean isExpandEmptyElements() {
        return true;
    }

    protected void loadOmitElementCloseSet(Set set) {
        set.add("AREA");
        set.add("BASE");
        set.add("BR");
        set.add("COL");
        set.add("HR");
        set.add("IMG");
        set.add("INPUT");
        set.add("LINK");
        set.add("META");
        set.add("P");
        set.add("PARAM");
    }

    protected boolean omitElementClose(String qualifiedName) {
        return this.getOmitElementCloseSet().contains(qualifiedName.toUpperCase());
    }

    public void startCDATA() throws SAXException {
    }

    public void write(CDATA cdata) throws IOException {
        this.writer.write(this.escapeElementEntities(cdata.getText()));
        this.lastOutputNodeType = 4;
    }

    public void write(Entity entity) throws IOException {
        this.writer.write(entity.getText());
        this.lastOutputNodeType = 5;
    }

    protected void writeClose(String qualifiedName) throws IOException {
        if (!this.omitElementClose(qualifiedName)) {
            super.writeClose(qualifiedName);
        }
    }

    protected void writeDeclaration() throws IOException {
    }

    protected void writeEmptyElementClose(String qualifiedName) throws IOException {
        if (!this.getOmitElementCloseSet().contains(qualifiedName.toUpperCase())) {
            super.writeEmptyElementClose(qualifiedName);
        } else {
            this.writer.write(">");
        }
    }
}

