/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/util/SingletonSortedMap.java,v 1.1 2003/02/28 04:39:41 frdm Exp $
 * $Revision: 1.1 $
 * $Date: 2003/02/28 04:39:41 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * <p>dlΏ㏑ SortedMap ̎łB
 * <p>̃NX͊{I TreeMap ƓłB
 * AAL[lقȂĂĂAl̃nbVȂȑO̒l̃R[h͍폜A
 * ̌ɒǉ܂B̃NX̃L[yђl null gp邱Ƃ͂ł܂B
 * L[yђl null gpƁANullPointerException X[܂B
 *
 * <p>.
 * key = a, value = A ƂR[h݂鎞ɁA
 * key = b, value = A ƂR[h put \bhŒǉꍇB
 * l key = a, value = A ̃R[h͍폜A
 * key = b, value = A ̃R[h put ܂B
 * 
 * ̃NX͂郊XǵAXVǗꍇɎgp܂B
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class SingletonSortedMap implements SortedMap, Serializable {
	private static final long serialVersionUID = 6119828374691483069L;
	/** {ƂȂ SortedMap */
	private SortedMap map;
	/** dlǗ Map IuWFNg */
	private Map valueMap;

	/**
	 * ̃}bv𐶐܂BL[IuWFNg̐TreeMapƓlłB
	 * @see java.util.TreeMap
	 */
	public SingletonSortedMap() {
		map = new TreeMap();
		valueMap = new HashMap();
	}

	/**
	 * w̃Rp[^ɏ]ă\[gꂽÃ}bv𐶐܂B
	 * @param c ̃}bv\[g邽߂ɎgpRp[^Bnull ĺAL[́uRtvgp邱Ƃ
	 */
	public SingletonSortedMap(Comparator c) {
		map = new TreeMap(c);
		valueMap = new HashMap();
	}

	/**
	 * w̃}bvƓ}bsOAL[́uRtvɏ]ă\[gꂽV}bv𐶐܂B
	 * @param m }bsÕ}bvɔzu}bv
	 */
	public SingletonSortedMap(Map m) {
		this();
		putAll(m);
	}

	/**
	 * w SortedMap Ɠ}bsOAtɏ]ă\[gꂽAV}bv쐬܂B̃\bh́A`ԂŎs܂B
	 * @param m }bsÕ}bvɔzuARp[^̃}bṽ\[gɎgpA\[gꂽ}bv
	 */
	public SingletonSortedMap(SortedMap m) {
		this(m.comparator());
		putAll(m);
	}

	/**
	 * w̒lƎw肳ꂽL[̃}bvɊ֘At܂B
	 * }bvȑOɂ̃L[̃}bsOێĂꍇAÂlu܂B
	 * ܂Aw̒lɃ}bsOĂꍇ́AÂlێGg[
	 * 폜AVɃL[̃}bsOs܂B
	 * @param key w肳l֘AtL[
	 * @param value w肳L[Ɋ֘Atl
	 * @return w肳ꂽL[Ɋ֘AlB܂́AL[̃}bsOȂꍇ nullB߂l null ́A}bvȑO null Ǝw肳ꂽL[֘AtĂƂꍇ
	 * @exception NullPointerException L[͒l null w肵
	 */
	public Object put(Object key, Object value) {
		if (key == null || value == null) {
			throw new NullPointerException();
		}
		
		Object o1 = map.get(key);
		if (valueMap.containsKey(o1)) {
			valueMap.remove(o1);
		}
		
		if (valueMap.containsKey(value)) {
			Object o2 = valueMap.get(value);
			valueMap.remove(value);
			map.remove(o2);
		}

		valueMap.put(value, key);
		Object o3 = map.put(key, value);
		if (map.size() != valueMap.size()) {
			throw new IllegalStateException("map size unmatch. (map : " + map.size() + " valueMap : " + valueMap.size() + ")");
		}
		return o3;
	}

	/**
	 * w̃}bv炷ׂẴ}bsO}bvɃRs[܂B
	 * ɂA}bvw̃}bvɌ݂L[ׂ̂Ăɑ΂
	 * Ă}bsOu܂B
	 * ܂Aw̒lɃ}bsOĂꍇ́AÂlێGg[
	 * 폜AVɃL[̃}bsOs܂B
	 * 
	 * @param t }bvɊi[}bsO 
	 */
	public void putAll(Map t) {
		for (Iterator it = t.entrySet().iterator(); it.hasNext();) {
			Entry e = (Entry) it.next();
			put(e.getKey(), e.getValue());
		}
	}
		
	/* (non-Javadoc)
	 * @see java.util.SortedMap#get()
	 */
	public Object get(Object key) {
		if (key == null) {
			throw new NullPointerException();
		}
		
		return map.get(key);
	}
		
	/* (non-Javadoc)
	 * @see java.util.SortedMap#size()
	 */
	public int size() {
		return map.size();
	}
		
	/* (non-Javadoc)
	 * @see java.util.SortedMap#comparator()
	 */
	public Comparator comparator() {
		return map.comparator();
	}

	/* (non-Javadoc)
	 * @see java.util.SortedMap#firstKey()
	 */
	public Object firstKey() {
		return map.firstKey();
	}

	/* (non-Javadoc)
	 * @see java.util.SortedMap#headMap(java.lang.Object)
	 */
	public SortedMap headMap(Object toKey) {
		if (toKey == null) {
			throw new NullPointerException();
		}
		
		return map.headMap(toKey);
	}

	/* (non-Javadoc)
	 * @see java.util.SortedMap#lastKey()
	 */
	public Object lastKey() {
		return map.lastKey();
	}

	/* (non-Javadoc)
	 * @see java.util.SortedMap#subMap(java.lang.Object, java.lang.Object)
	 */
	public SortedMap subMap(Object fromKey, Object toKey) {
		if (fromKey == null || toKey == null) {
			throw new NullPointerException();
		}
		
		return map.subMap(fromKey, toKey);
	}

	/* (non-Javadoc)
	 * @see java.util.SortedMap#tailMap(java.lang.Object)
	 */
	public SortedMap tailMap(Object fromKey) {
		if (fromKey == null) {
			throw new NullPointerException();
		}
		
		return map.tailMap(fromKey);
	}

	/* (non-Javadoc)
	 * @see java.util.Map#clear()
	 */
	public void clear() {
		map.clear();
		valueMap.clear();
	}

	/* (non-Javadoc)
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	public boolean containsKey(Object key) {
		if (key == null) {
			throw new NullPointerException();
		}
		

		return map.containsKey(key);
	}

	/* (non-Javadoc)
	 * @see java.util.Map#containsValue(java.lang.Object)
	 */
	public boolean containsValue(Object value) {
		if (value == null) {
			throw new NullPointerException();
		}
		
		return map.containsValue(value);
	}

	/**
	 * ێĂ SortedMap  entrySet Ԃ܂B
	 * AAԂ Set ͕ύX邱Ƃł܂B̎͌ɂ SortedMap C^[tFCX
	 * Ă܂B
	 * 
	 * @return ύXsentrySet
	 */
	public Set entrySet() {
		return Collections.unmodifiableSet(map.entrySet());
	}

	/* (non-Javadoc)
	 * @see java.util.Map#isEmpty()
	 */
	public boolean isEmpty() {
		return map.isEmpty();
	}

	/**
	 * ێĂ SortedMap  keySet Ԃ܂B
	 * AAԂ Set ͕ύX邱Ƃł܂B̎͌ɂ SortedMap C^[tFCX
	 * Ă܂B
	 * 
	 * @return ύXskeySet
	 */
	public Set keySet() {
		return Collections.unmodifiableSet(map.keySet());
	}

	/* (non-Javadoc)
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	public Object remove(Object key) {
		if (key == null) {
			throw new NullPointerException();
		}
		
		Object o = map.remove(key);
		if (valueMap.containsKey(o)) {
			valueMap.remove(o);
		}

		if (map.size() != valueMap.size()) {
			throw new IllegalStateException("map size unmatch. (map : " + map.size() + " valueMap : " + valueMap.size() + ")");
		}
		return o;
	}

	/**
	 * ێĂ SortedMap  l Collection r[Ԃ܂B
	 * AAԂ Collection ͕ύX邱Ƃł܂B̎͌ɂ SortedMap C^[tFCX
	 * Ă܂B
	 * 
	 * @return ύXs̒l Collection r[
	 */
	public Collection values() {
		return Collections.unmodifiableCollection(map.values());
	}
	
	/**
	 * ێĂ Map IuWFNgŃnbV𐶐܂B
	 */
	public int hashCode() {
		int result = 17;
		result = 37 * result + map.hashCode();
		result = 37 * result + valueMap.hashCode();
		return result;
	}

	/**
	 * ێĂ Map IuWFNgŔr܂B
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof SingletonSortedMap)) {
			return false;
		}
		SingletonSortedMap m = (SingletonSortedMap) obj;
		return m.map.equals(map)
				&& m.valueMap.equals(valueMap);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("map{").append(map.toString()).append("}");
		buffer.append("valueMap{").append(valueMap.toString()).append("}");
		return buffer.toString();
	}
	
	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new SingletonSortedMap(map);
	}
}
