/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.util;

import static org.F11.scada.cat.util.CollectionUtil.list;

import java.awt.Insets;
import java.util.Collections;
import java.util.List;

import org.xml.sax.Attributes;

/**
 * IuWFNg[eBeB[NXłB
 *
 * @author maekawa
 */
public abstract class AttributesUtil {
	/**
	 * ̒lԂ܂BAAlw肳ĂȂꍇEk̏ꍇ́AnullԂ܂B
	 *
	 * @param attname 
	 * @param atts IuWFNg
	 * @return ̒lԂ܂B
	 */
	public static String getValue(String attname, Attributes atts) {
		return getNonNullString(atts.getValue(attname));
	}

	/**
	 *  null 󔒂̏ꍇ null ȊȌꍇ͈̕Ԃ܂B
	 *
	 * @param str 肷镶
	 * @return  null 󔒂̏ꍇ null ȊȌꍇ͈̕Ԃ܂B
	 */
	public static String getNonNullString(String str) {
		return (str == null || "".equals(str)) ? null : str;
	}

	/**
	 * ̒lbooleanŕԂ܂BAAlw肳ĂȂꍇEk̏ꍇ́AfalseԂ܂B
	 * l̔ɂBoolean#valueOf\bhgpĂ܂B
	 *
	 * @param attname 
	 * @param atts IuWFNg
	 * @return ̒lԂ܂B
	 * @see Boolean#valueOf(java.lang.String)
	 */
	public static boolean getBooleanValue(String attname, Attributes atts) {
		return Boolean.valueOf(getValue(attname, atts)).booleanValue();
	}

	/**
	 * ̕ null  󔒂̏ꍇ true Ԃ܂B
	 *
	 * @param str 肷镶
	 * @return ̕ null  󔒂̏ꍇ true Ԃ܂B
	 */
	public static boolean isSpaceOrNull(String str) {
		return str == null || "".equals(str);
	}

	public static long getLongValue(String s) {
		if (isSpaceOrNull(s)) {
			return 0L;
		} else {
			try {
				return Long.parseLong(s);
			} catch (Exception e) {
				return 0L;
			}
		}
	}

	/**
	 *  null 󔒂Ȃ null ȊȌꍇ"%"ň͂񂾕Ԃ܂B
	 *
	 * @param s 
	 * @return  null 󔒂Ȃ null ȊȌꍇ"%"ň͂񂾕Ԃ܂B
	 */
	public static String getLikeString(String s) {
		return isSpaceOrNull(s) ? null : "%" + s + "%";
	}

	/**
	 * ̕u,vŕ܂
	 *
	 * @param tables e[uu,vŋ؂
	 * @return e[u΃e[ũXg𖳂΋̃XgԂ܂B
	 */
	public static List<String> getTables(String tables) {
		if (null != tables) {
			List<String> l = list();
			String[] s = tables.split("\\,");
			for (String string : s) {
				l.add(string.trim());
			}
			return l;
		} else {
			return Collections.emptyList();
		}
	}

	public static Insets getInsets(String is) {
		if (is != null) {
			String[] s = is.split(",");
			return new Insets(getNumber(s[0].trim()), getNumber(s[1].trim()),
					getNumber(s[2].trim()), getNumber(s[3].trim()));
		} else {
			return new Insets(50, 80, 60, 50);
		}
	}

	private static int getNumber(String string) {
		return Integer.parseInt(string);
	}

	public static int getIntegerValue(String s, int init) {
		if (isSpaceOrNull(s)) {
			return init;
		} else {
			try {
				return Integer.parseInt(s);
			} catch (Exception e) {
				return init;
			}
		}
	}
}
