/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.io.nio;

import java.sql.Timestamp;
import java.util.List;

/**
 * MOe[u𑀍삷DaoC^[tFCXłB
 * @author maekawa
 */
public interface LogTableDao {
	/**
	 * w肵e[uLogDtõXg̓eob`}܂B
	 * @param tableName e[u
	 * @param dtos LogDtõXg
	 * @return }R[h
	 */
	int insert(String tableName, List dtos);
	/**
	 * rW擾܂B
	 * @param tableName e[u
	 * @param time Cxg
	 * @param holderId z_ID
	 * @return rW擾܂B
	 */
	int getRevision(String tableName, Timestamp time, String holderId);
	/**
	 * w肵Oe[ȗSR[hԂ܂B
	 * @param tableName e[u
	 * @return w肵Oe[ȗSR[hԂ܂B
	 */
	List select(String tableName);
	/**
	 * w肵Oe[uÃf[^z_ƍő僌R[hŃR[h𒊏o܂B
	 * @param tableName e[u
	 * @param holderId f[^z_ID
	 * @param limit ő僌R[h
	 * @return w肵Oe[uÃf[^z_ƍő僌R[hŃR[h𒊏o܂B
	 */
	List select(String tableName, String holderId, int limit);
	/**
	 * Ŏw肵VR[h̃XgԂ܂B
	 * @param tableName e[u
	 * @param dataHolders of[^z_[ID
	 * @param time of[^z_[̌
	 * @return Ŏw肵VR[h̃XgԂ܂B
	 */
	List select(String tableName, String holderId, Timestamp time);
	/**
	 * e[u̍ŌÃR[hԂ܂B
	 * @param tableName e[u
	 * @param holderId f[^z_[ID
	 * @return e[u̍ŌÃR[hԂ܂B
	 */
	List selectFirst(String tableName, String holderId);
	/**
	 * e[u̍ŐVR[hԂ܂B
	 * @param tableName e[u
	 * @param holderId f[^z_[ID
	 * @return e[u̍ŐVR[hԂ܂B
	 */
	List selectLast(String tableName, String holderId);

	/**
	 * ÂR[h𒊏o܂
	 * @param tableName e[u
	 * @param holderId z_ID
	 * @param start 
	 * @param limit R[h
	 * @return ÂR[h𒊏o܂
	 */
	List selectBefore(String tableName, String holderId, Timestamp start, int limit);

	/**
	 * ȏVR[h𒊏o܂
	 * @param tableName e[u
	 * @param holderId z_ID
	 * @param start 
	 * @param limit R[h
	 * @return ȏVR[h𒊏o܂
	 */
	List selectAfter(String tableName, String holderId, Timestamp start, int limit);

	/**
	 * Ŏw肵ŃR[hLoggingDatãXgԂ܂B
	 * @param tableName e[u
	 * @param holderId of[^z_[
	 * @param startTime of[^z_[̌
	 * @param endTime of[^z_[̌
	 * @return Ŏw肵VR[hLoggingDatãXgԂ܂B
	 */
	List select(String tableName, String holderId, Timestamp startTime, Timestamp endTime);
}
