package org.F11.scada.server.io;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

import org.F11.scada.data.LoggingRowData;

/**
 * ̃NG[yёSf[^̃R[hZbgԂC^[tFCXłB
 */
public interface SelectHandler {
	/** e[u݂Ȃꍇ̗Oł */
	public static final String TABLE_NOT_FOUND = "Table not found";

	/**
	 * w肳ꂽ LoggingRowDatãXgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @return w肳ꂽ LoggingRowDatãXgԂ܂B
	 * @exception SQLException SQLG[ꍇ
	 */
	public List select(String name, List dataHolders) throws SQLException;

	/**
	 * w肳ꂽ LoggingRowDatãXgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @return w肳ꂽ LoggingRowDatãXgԂ܂B
	 * @exception SQLException SQLG[ꍇ
	 */
	public List select(String name, List dataHolders, int limit)
			throws SQLException;

	/**
	 * w肳ꂽ LoggingRowDatatimeȍ~̃XgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg
	 * @param time Ԃf[^̌
	 * @return w肳ꂽ LoggingRowDatãXgԂ܂B
	 * @throws SQLException
	 */
	public List select(String name, List dataHolders, Timestamp time)
			throws SQLException;

	/**
	 * e[u̍łÂR[hԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @return e[u̍łÂR[hԂ܂B
	 * @throws SQLException
	 */
	public LoggingRowData first(String name, List dataHolders)
			throws SQLException;

	/**
	 * e[u̍łVR[hԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @return e[u̍łVR[hԂ܂B
	 * @throws SQLException
	 */
	public LoggingRowData last(String name, List dataHolders)
			throws SQLException;

	/**
	 * w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg
	 * @param start Ԃf[^̌Ԃ̓
	 * @param limit ő僌R[h
	 * @return w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * @throws SQLException
	 */
	public List selectBeforeAfter(
			String name,
			List dataHolders,
			Timestamp start,
			int limit) throws SQLException;

	/**
	 * w肳ꂽ LoggingRowDatãXgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @param limit 擾f[^R[h
	 * @param table gpe[u
	 * @return w肳ꂽ LoggingRowDatãXgԂ܂B
	 * @exception SQLException SQLG[ꍇ
	 */
	public List<LoggingRowData> select(
			String name,
			List dataHolders,
			int limit,
			List<String> table) throws SQLException;

	/**
	 * w肳ꂽ LoggingRowDatatimeȍ~̃XgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg
	 * @param time Ԃf[^̌
	 * @param tables gpe[u
	 * @return w肳ꂽ LoggingRowDatãXgԂ܂B
	 * @throws SQLException
	 */
	public List select(
			String name,
			List dataHolders,
			Timestamp time,
			List<String> tables) throws SQLException;

	/**
	 * w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg
	 * @param start Ԃf[^̌Ԃ̓
	 * @param limit ő僌R[h
	 * @param tables gpe[u
	 * @return w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * @throws SQLException
	 */
	public List selectBeforeAfter(
			String name,
			List dataHolders,
			Timestamp start,
			int limit,
			List<String> tables) throws SQLException;

	/**
	 * e[u̍łÂR[hԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @return e[u̍łÂR[hԂ܂B
	 * @throws SQLException
	 */
	public LoggingRowData first(
			String name,
			List dataHolders,
			List<String> tables) throws SQLException;

	/**
	 * e[u̍łVR[hԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg(̏)
	 * @return e[u̍łVR[hԂ܂B
	 * @throws SQLException
	 */
	public LoggingRowData last(
			String name,
			List dataHolders,
			List<String> tables) throws SQLException;

	/**
	 * w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg
	 * @param start Ԃf[^̌擪̓
	 * @param end Ԃf[^̌̓
	 * @return w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * @throws SQLException
	 */
	public List selectPeriod(
			String name,
			List dataHolders,
			Timestamp start,
			Timestamp end) throws SQLException;

	/**
	 * w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * 
	 * @param name f[^\[X
	 * @param dataHolders f[^z_̃Xg
	 * @param start Ԃf[^̌擪̓
	 * @param end Ԃf[^̌̓
	 * @param tables gpe[u
	 * @return w肳ꂽ LoggingRowData̎w肵Ԃ̃XgԂ܂B
	 * @throws SQLException
	 */
	public List selectPeriod(
			String name,
			List dataHolders,
			Timestamp start,
			Timestamp end,
			List<String> tables) throws SQLException;
}
