package org.F11.scada.server.io;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;

import org.F11.scada.server.event.LoggingDataListener;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/**
 * f[^nh[̃t@Ng[NXłB getHandlerFactory \bhŁAw̃t@Ng[IuWFNg𐶐܂B
 * 
 * @see#getHandlerFactory() <!-- Abstract Factory Pattern gpĂ܂B -->
 */
public abstract class HandlerFactory {
	/**
	 * Ŏw肵NX́At@Ng[IuWFNg𐶐܂B
	 * 
	 * @param className t@Ng[IuWFNg
	 * @return ꂽt@Ng[IuWFNg̃CX^X
	 */
	public static HandlerFactory getHandlerFactory(String className) {
		HandlerFactory factory = null;
		try {
			factory = (HandlerFactory) Class.forName(className).newInstance();
		} catch (ClassNotFoundException ex) {
			System.out.println("NX " + className + " ܂B");
		} catch (Exception ex2) {
			ex2.printStackTrace();
		}
		return factory;
	}

	/**
	 * f[^XVpf[^nhԂt@Ng[\bhłBTuNXŎĂB
	 * 
	 * @param device foCX(ʏ̓e[uAt@C)
	 * @param isPadding TODO
	 * @return f[^XVpf[^nh
	 * @exception SQLException DBMSRlNgsƂX[܂B
	 */
	public abstract LoggingDataListener createStoreHandler(String device, boolean isPadding)
			throws SQLException;

	/**
	 * NCAgnhC^[tFCXIuWFNgԂt@Ng[\bhłBTuNXŎĂB
	 * 
	 * @param device foCX(ʏ̓e[uAt@C)
	 * @param dataHolders f[^z_[̃Xg
	 * @return NCAgnhC^[tFCXIuWFNgԂt@Ng[
	 * @exception MalformedURLException OK؂Ȍ` URL łȂꍇ
	 * @exception RemoteException RMIWXgɐڑłȂꍇ
	 */
	public abstract ValueListHandlerElement createValueListHandler(
			String device,
			List dataHolders)
			throws MalformedURLException,
			RemoteException,
			SQLException;

	/**
	 * Otp̃ZNgnhԂ܂B
	 * 
	 * @param device e[u
	 * @return Otp̃ZNgnhԂ܂B
	 */
	public abstract SelectiveValueListHandlerElement createSelectviveHandler(
			String device,
			List<String> tables);

	/**
	 * Otp̑Sf[^nhԂ܂B
	 * 
	 * @param device e[u
	 * @return Otp̑Sf[^nhԂ܂B
	 */
	public abstract SelectiveAllDataValueListHandlerElement createAllDataSelectviveHandler(
			String device,
			List<String> tables);
}
