/*
 * Projrct F-11 - Web SCADA for Java Copyright (C) 2002 Freedom, Inc. All Rights
 * Reserved. This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

package org.F11.scada.server.communicater;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.F11.scada.WifeException;
import org.F11.scada.WifeUtilities;
import org.F11.scada.server.converter.Converter;
import org.F11.scada.server.event.WifeCommand;
import org.F11.scada.server.event.WifeEventListener;
import org.apache.log4j.Logger;

/**
 * PLCƂ̒ʐMsNXłB
 */
public final class PlcCommunicater implements Communicater {
	private final static Logger log = Logger.getLogger(PlcCommunicater.class);
	/** [hCgbNIuWFNg */
	private final ReadWriteLock lock = new ReadWriteLock();
	/** foCX */
	private Environment device;
	/** MM҂IuWFNg */
	private ReplyWaiter waiter;
	/** vgRRo[^ */
	private Converter converter;
	/** ʐMR}hWǗIuWFNg */
	private volatile LinkageCommand linkageCommand;

	/** Mobt@ */
	private ByteBuffer sendBuffer = ByteBuffer.allocateDirect(2048);
	/** Mobt@ */
	private ByteBuffer recvBuffer = ByteBuffer.allocateDirect(2048);
	/** Ǎ݃f[^obt@ */
	private ByteBuffer recvData = ByteBuffer.allocateDirect(2048);
	/** FINS/TCPvgRʐM̗L */
	private boolean isFinsTcp;

	/**
	 * RXgN^[
	 * @param device foCX
	 * @param converter vgR̃Ro[^
	 * @param listener Mf[^t惊Xi[
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public PlcCommunicater(Environment device, Converter converter)
			throws IOException, InterruptedException {
		if ("UDP".equals(device.getDeviceKind())) {
			byte[] header = converter.setEnvironment(device);
			waiter = new UdpReplyWaiter(device, header);
		} else if ("TCP".equals(device.getDeviceKind())) {
			byte[] header = converter.setEnvironment(device);
			waiter = new TcpReplyWaiter(device, header);
		} else {
			throw new IllegalArgumentException("not support "
					+ device.getDeviceKind());
		}

		this.device = device;
		this.converter = converter;
		this.linkageCommand = new LinkageCommand(converter);
		this.isFinsTcp = isFinsTcp(device);
	}

	private boolean isFinsTcp(Environment device) {
		return "TCP".equalsIgnoreCase(device.getDeviceKind())
			&& "FINSTCP".equalsIgnoreCase(device.getPlcCommKind());
	}

	// @see org.F11.scada.server.communicater.Communicater#close()
	public void close() throws InterruptedException {
		lock.writeLock();
		try {
			log.debug("close()");
			waiter.close();
		} finally {
			lock.writeUnlock();
		}
	}

	public void addReadCommand(Collection<WifeCommand> commands) {
		linkageCommand.addDefine(commands);
	}

	public void removeReadCommand(Collection<WifeCommand> commands) {
		linkageCommand.removeDefine(commands);
	}

	// @see
	// org.F11.scada.server.communicater.Communicater#syncRead(java.util.Collection)
	public Map<WifeCommand, byte[]> syncRead(Collection<WifeCommand> commands)
			throws InterruptedException, IOException, WifeException {

		return syncRead(commands, true);
	}

	/*
	 * (non-Javadoc)
	 * @see
	 * org.F11.scada.server.communicater.Communicater#syncRead(java.util.Collection
	 * , boolean)
	 */
	public Map<WifeCommand, byte[]> syncRead(Collection<WifeCommand> commands,
			boolean sameDataBalk) throws InterruptedException, IOException,
			WifeException {
		lock.readLock();
		try {
			log.debug("syncRead(" + commands.size() + ")");
			// WR}h擾
			Collection<WifeCommand> lk_commands = linkageCommand.getDefines(commands);
			HashMap<WifeCommand, byte[]> commandDataMap = new HashMap<WifeCommand, byte[]>(
					lk_commands.size());
			for (Iterator<WifeCommand> it = lk_commands.iterator(); it.hasNext();) {
				WifeCommand lk_comm = it.next();

				// ǍݒʐM
				converter.setReadCommand(lk_comm);
				sendrecv();

				if (sameDataBalk
						&& !linkageCommand.updateDefine(lk_comm, recvData)) {
					continue;
				}

				// WR}hSĂ̌R}h擾itQƁj
				Collection<WifeCommand> dh_commands = linkageCommand.getHolderCommands(lk_comm);
				// vĂȂR}h폜
				dh_commands.retainAll(commands);
				for (Iterator<WifeCommand> it2 = dh_commands.iterator(); it2.hasNext();) {
					WifeCommand dh_comm = it2.next();
					// vς݂̃R}hɂāAf[^𑗕t
					int byteOffset = (int) (dh_comm.getMemoryAddress() - lk_comm.getMemoryAddress()) * 2;
					byte[] cutdata = new byte[dh_comm.getWordLength() * 2];
					recvData.position(byteOffset);
					recvData.get(cutdata);
					commandDataMap.put(dh_comm, cutdata);
				}
			}
			return commandDataMap;
		} finally {
			lock.readUnlock();
		}
	}

	// @see
	// org.F11.scada.server.communicater.Communicater#syncWrite(java.util.Collection,
	// java.util.Map)
	public void syncWrite(Map<WifeCommand, byte[]> commands)
			throws InterruptedException, IOException, WifeException {
		lock.writeLock();
		try {
			log.debug("syncWrite(" + commands.size() + ")");
			for (Iterator<WifeCommand> it = commands.keySet().iterator(); it.hasNext();) {
				WifeCommand comm = it.next();
				byte[] data = commands.get(comm);
				if (data == null) {
					throw new IllegalArgumentException("datas not found");
				}

				// ݒʐM
				converter.setWriteCommand(comm, data);
				sendrecv();
			}
		} finally {
			lock.writeUnlock();
		}
	}

	/*
	 * Ro[^̌ʂɊʐM܂B Ro[^ݒς݂ł邱ƁB s񐔒ߎɁAŏI̗O܂B
	 */
	private void sendrecv() throws IOException, WifeException,
			InterruptedException {
		recvData.clear();
		while (converter.hasCommand()) {
			sendBuffer.clear();
			converter.nextCommand(sendBuffer);
			sendBuffer.flip();
			// MM҂
			waiter.syncSendRecv(sendBuffer, recvBuffer);
			WifeException ex = checkError();
			// G[Ȃ玎sJԂ
			for (int i = 0; i < device.getPlcRetryCount() && ex != null; i++) {
				if (ex != null) {
					log.warn("ID[" + device.getDeviceID() + "] try["
							+ String.valueOf(i) + "] error[" + ex.getMessage()
							+ "]");
				}
				sendBuffer.clear();
				converter.retryCommand(sendBuffer);
				sendBuffer.flip();
				// MM҂
				waiter.syncSendRecv(sendBuffer, recvBuffer);
				ex = checkError();
			}
			// G[Ȃ΁AdPLCƒʐM
			if (ex != null && device.getPlcIpAddress2() != null
					&& 0 < device.getPlcIpAddress2().length()) {

				// ʐMIP؂ւ
				waiter.change2sub();

				recvData.clear();
				sendBuffer.clear();
				converter.retryCommand(sendBuffer);
				sendBuffer.flip();
				// MM҂
				waiter.syncSendRecv(sendBuffer, recvBuffer);
				ex = checkError();
				// G[Ȃ玎sJԂ
				for (int i = 0; i < device.getPlcRetryCount() && ex != null; i++) {
					if (ex != null) {
						log.warn("ID[" + device.getDeviceID()
								+ "] changed try[" + String.valueOf(i)
								+ "] error[" + ex.getMessage() + "]");
					}
					sendBuffer.clear();
					converter.retryCommand(sendBuffer);
					sendBuffer.flip();
					// MM҂
					waiter.syncSendRecv(sendBuffer, recvBuffer);
					ex = checkError();
				}
			}
			// FINS/TCPŃG[Ȃ΃|[găI[v
			if (ex != null && isFinsTcp) {
				// ʐMIP؂ւ
				waiter.reOpenPort();

				recvData.clear();
				sendBuffer.clear();
				converter.retryCommand(sendBuffer);
				sendBuffer.flip();
				// MM҂
				waiter.syncSendRecv(sendBuffer, recvBuffer);
				ex = checkError();
				// G[Ȃ玎sJԂ
				for (int i = 0; i < device.getPlcRetryCount() && ex != null; i++) {
					if (ex != null) {
						log.warn("ID[" + device.getDeviceID()
								+ "] changed try[" + String.valueOf(i)
								+ "] error[" + ex.getMessage() + "]");
					}
					sendBuffer.clear();
					converter.retryCommand(sendBuffer);
					sendBuffer.flip();
					// MM҂
					waiter.syncSendRecv(sendBuffer, recvBuffer);
					ex = checkError();
				}
			}

			if (ex != null) {
				log.warn("ID[" + device.getDeviceID() + "] error decision["
						+ ex.getMessage() + "]");
				throw ex;
			}
			// Mf[^ǉ
			converter.getResponceData(recvBuffer, recvData);
		}
		recvData.flip();
	}

	private WifeException checkError() throws WifeException,
			InterruptedException {
		WifeException ex = null;
		if (recvBuffer.remaining() <= 0) {
			// f[^̓^CAEg
			sendBuffer.flip();
			ex = new WifeException(0, 0, "Recved time out. "
					+ WifeUtilities.toString(sendBuffer));
		} else {
			ex = converter.checkCommandResponce(recvBuffer);
			if (ex != null) {
				// ^CAEgȊÕG[ȂΎs̑Oɑ҂
				Thread.sleep(device.getPlcTimeout());
			}
		}
		return ex;
	}

	/*
	 * (non-Javadoc)
	 * @see
	 * org.F11.scada.server.communicater.Communicater#addWifeEventListener(org
	 * .F11.scada.server.event.WifeEventListener)
	 */
	public void addWifeEventListener(WifeEventListener l) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * @see
	 * org.F11.scada.server.communicater.Communicater#removeWifeEventListener
	 * (org.F11.scada.server.event.WifeEventListener)
	 */
	public void removeWifeEventListener(WifeEventListener l) {
		throw new UnsupportedOperationException();
	}
}