/*
 * Projrct F-11 - Web SCADA for Java Copyright (C) 2002 Freedom, Inc. All Rights
 * Reserved. This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

package org.F11.scada.server.communicater;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;

import org.F11.scada.server.converter.Converter;
import org.F11.scada.server.event.WifeCommand;
import org.apache.log4j.Logger;

/**
 * @author hori WifeCommand̏WǗNXłB
 */
public final class LinkageCommand {
	private static Logger log = Logger.getLogger(LinkageCommand.class);

	/**
	 * WpRp[^ ̒ʐMGASɕꍇɓƌȂ܂B ʐM`Wׂ̌Ɏgp܂B
	 */
	private final Comparator<WifeCommand> comp = new Comparator<WifeCommand>() {
		public int compare(WifeCommand wc1, WifeCommand wc2) {
			if (wc1.getDeviceID().compareTo(wc2.getDeviceID()) < 0)
				return -1;
			else if (wc1.getDeviceID().compareTo(wc2.getDeviceID()) > 0)
				return 1;

			if (wc1.getCycleMode() < wc2.getCycleMode())
				return -1;
			else if (wc1.getCycleMode() > wc2.getCycleMode())
				return 1;

			if (wc1.getMemoryMode() < wc2.getMemoryMode())
				return -1;
			else if (wc1.getMemoryMode() > wc2.getMemoryMode())
				return 1;

			if (wc1.getMemoryAddress() < wc2.getMemoryAddress()
					&& wc1.getMemoryAddress() + wc1.getWordLength() < wc2.getMemoryAddress()
							+ wc2.getWordLength())
				return -1;
			if (wc2.getMemoryAddress() < wc1.getMemoryAddress()
					&& wc2.getMemoryAddress() + wc2.getWordLength() < wc1.getMemoryAddress()
							+ wc1.getWordLength())
				return 1;

			return 0;
		}
	};

	/* ʐM`̏W */
	protected final SortedMap<WifeCommand, DefineData> lk_commands = new TreeMap<WifeCommand, DefineData>(
			comp);
	/* Ro[^ */
	private final Converter converter;

	/* ʐM񐔎WtO */
	private boolean countGo = false;

	public LinkageCommand(Converter converter) {
		this.converter = converter;

		if (log.isDebugEnabled()) {
			Timer timer = new Timer();
			timer.schedule(new TimerTask() {
				public void run() {
					startCount();
				}
			}, 10L * 60L * 1000L);
			timer.schedule(new TimerTask() {
				public void run() {
					stopCount();
				}
			}, 20L * 60L * 1000L);
			timer.schedule(new TimerTask() {
				public void run() {
					log.debug(getCountString());
				}
			}, 21L * 60L * 1000L);
		}
	}

	/**
	 * z_ʐM`̃RNVWɒǉ܂B
	 * @param defines \[gʐM`RNV
	 */
	public void addDefine(Collection<WifeCommand> dh_commands) {
		// QƌŃXg𗘗pĂ邱ƂׁARs[Xg\[gĎgpB
		ArrayList<WifeCommand> commands = new ArrayList<WifeCommand>(
				dh_commands);
		Collections.sort(commands, comp);
		for (Iterator<WifeCommand> i = commands.iterator(); i.hasNext();) {
			WifeCommand command = i.next();
			addDefine(command);
		}
	}

	/**
	 * z_ʐM`Wɒǉ܂B
	 * @param define ǉʐM`
	 */
	public synchronized void addDefine(WifeCommand dh_command) {
		// ̏Wvvf
		if (lk_commands.keySet().contains(dh_command)) {
			WifeCommand wc = lk_commands.tailMap(dh_command).firstKey();
			DefineData df = lk_commands.get(wc);
			df.addCommand(dh_command);
			// vvfWordLengthꍇ
			if (wc.getWordLength() < dh_command.getWordLength()) {
				lk_commands.remove(wc);
				lk_commands.put(dh_command, df);
			}
			return;
		}

		// ̏Wg\ȗvf
		WifeCommand wc1 = null;
		WifeCommand wc2 = null;
		WifeCommand wc1e = null;
		WifeCommand wc2e = null;
		SortedMap<WifeCommand, DefineData> head = lk_commands.headMap(dh_command);
		if (!head.isEmpty()) {
			// L[菬vf쐬BgɎsꍇ nulllB
			wc1 = (WifeCommand) head.lastKey();
			wc1e = createExpandedCommand(wc1, dh_command);
		}
		SortedMap<WifeCommand, DefineData> tail = lk_commands.tailMap(dh_command);
		if (!tail.isEmpty()) {
			// L[傫vf쐬BgɎsꍇ nulllB
			wc2 = (WifeCommand) tail.firstKey();
			wc2e = createExpandedCommand(wc2, dh_command);
		}
		if (wc1e != null && wc2e != null) {
			// gWordLength̗p
			if (wc1e.getWordLength() <= wc2e.getWordLength()) {
				DefineData df = (DefineData) lk_commands.remove(wc1);
				df.addCommand(dh_command);
				lk_commands.put(wc1e, df);
			} else {
				DefineData df = (DefineData) lk_commands.remove(wc2);
				df.addCommand(dh_command);
				lk_commands.put(wc2e, df);
			}
			return;
		} else if (wc1e != null) {
			DefineData df = (DefineData) lk_commands.remove(wc1);
			df.addCommand(dh_command);
			lk_commands.put(wc1e, df);
			return;
		} else if (wc2e != null) {
			DefineData df = (DefineData) lk_commands.remove(wc2);
			df.addCommand(dh_command);
			lk_commands.put(wc2e, df);
			return;
		}

		// gs\̂Œǉ
		DefineData df = new DefineData();
		df.addCommand(dh_command);
		lk_commands.put(dh_command, df);
	}

	public void removeDefine(Collection<WifeCommand> dh_commands) {
		// ArrayList commands = new ArrayList(dh_commands);
		// Collections.sort(commands, comp);
		// for (Iterator i = commands.iterator(); i.hasNext();) {
		// WifeCommand command = (WifeCommand) i.next();
		// removeDefine(command);
		// }
	}

	public void removeDefine(WifeCommand dh_command) {
		if (lk_commands.containsKey(dh_command)) {
			DefineData df = (DefineData) lk_commands.get(dh_command);
			df.removeDefine(dh_command);
		}
	}

	/**
	 * z_ʐM`̃RNV܂ޒʐMvXg𒊏o܂B ̏Ww̒ʐM`܂ޒʐM`ARNV܂B
	 * WɂȂʐM`́Â܂ܒǉ܂B
	 * @param commands oL[ɂȂʐM`
	 * @return oʐM`̃RNV
	 */
	public synchronized Collection<WifeCommand> getDefines(
			Collection<WifeCommand> dh_commands) {
		SortedSet<WifeCommand> reqtbl = new TreeSet<WifeCommand>(comp);
		for (Iterator<WifeCommand> it = dh_commands.iterator(); it.hasNext();) {
			WifeCommand dh_comm = it.next();

			// 쐬ς݂̒ʐMvXg
			if (reqtbl.contains(dh_comm)) {
				WifeCommand wc = (WifeCommand) reqtbl.tailSet(dh_comm).first();
				if (dh_comm.getWordLength() <= wc.getWordLength()) {
					continue;
				}
			}
			// ̏W
			if (lk_commands.keySet().contains(dh_comm)) {
				WifeCommand wc = lk_commands.tailMap(dh_comm).firstKey();
				if (dh_comm.getWordLength() <= wc.getWordLength()) {
					reqtbl.add(lk_commands.tailMap(dh_comm).firstKey());
					continue;
				}
			}
			// WɂȂʐM`
			throw new IllegalArgumentException("not added command. " + dh_comm);
		}
		return reqtbl;
	}

	/**
	 * ʐMʂőOlXV܂B
	 * @param command ʐM`̃L[
	 * @param readData ʐM
	 * @return z_lXVKvꍇ true
	 */
	public synchronized boolean updateDefine(WifeCommand command,
			ByteBuffer readData) {
		// WɂȂR}h̒ʐMʂ͏Ƀz_lXV
		DefineData df = lk_commands.get(command);
		if (df == null)
			return true;

		if (countGo) {
			// ʐM񐔎W
			df.countup();
		}

		byte[] data = new byte[readData.remaining()];
		readData.get(data);
		return df.updateData(data);
	}

	/**
	 * WɃNꂽz_ʐM`̃RNVԂ܂B
	 * @param command W̃L[
	 * @return z_ʐM`̃RNVB
	 */
	public synchronized Collection<WifeCommand> getHolderCommands(
			WifeCommand command) {
		DefineData df = lk_commands.get(command);
		if (df == null) {
			throw new IllegalArgumentException("not find LinkageCommand."
					+ command.toString());
		}
		return df.getDefines();
	}

	/**
	 * ʐM񐔃JEgJn܂B
	 */
	public synchronized void startCount() {
		countGo = true;
	}

	/**
	 * ʐM񐔃JEg~܂B
	 */
	public synchronized void stopCount() {
		countGo = false;
	}

	/**
	 * ʐM񐔂̕\Ԃ܂B
	 * @return
	 */
	public synchronized String getCountString() {
		StringBuffer sb = new StringBuffer();
		sb.append("Communication counter\n");
		for (Iterator<WifeCommand> it = lk_commands.keySet().iterator(); it.hasNext();) {
			WifeCommand wc = it.next();
			DefineData df = lk_commands.get(wc);
			sb.append(wc.toString()).append("\n");
			sb.append(df.getCountString());
			sb.append("------------------------------\n");
		}
		return sb.toString();
	}

	/*
	 * Q̒ʐMGAʐM`V쐬܂B @param src ʐM` @param dest ʐM` @return
	 * 쐬ꂽʐM`Bs\ȏꍇ nullB
	 */
	private WifeCommand createExpandedCommand(WifeCommand src, WifeCommand dest) {
		if (!src.getDeviceID().equals(dest.getDeviceID())
				|| src.getCycleMode() != dest.getCycleMode()
				|| src.getMemoryMode() != dest.getMemoryMode()) {
			return null;
		}
		if (dest.getMemoryAddress() < src.getMemoryAddress()
				&& src.getMemoryAddress() + src.getWordLength() <= dest.getMemoryAddress()
						+ converter.getPacketMaxSize(src)) {
			long len = src.getMemoryAddress() + src.getWordLength()
					- dest.getMemoryAddress();
			if (len < dest.getWordLength()) {
				len = dest.getWordLength();
			}

			return src.createCommand(dest.getMemoryAddress(), (int) len);
		} else if (src.getMemoryAddress() <= dest.getMemoryAddress()
				&& dest.getMemoryAddress() + dest.getWordLength() <= src.getMemoryAddress()
						+ converter.getPacketMaxSize(src)) {
			long len = dest.getMemoryAddress() + dest.getWordLength()
					- src.getMemoryAddress();
			if (len < src.getWordLength()) {
				len = src.getWordLength();
			}

			return src.createCommand(src.getMemoryAddress(), (int) len);
		}
		return null;
	}

	/*
	 * W̗vfɕte\NXB
	 */
	private final class DefineData {
		/* z_ʐM`ւ̎Q */
		private final Collection<WifeCommand> commands = new HashSet<WifeCommand>();
		/* ʐM`̑Ol */
		private byte[] oldData = new byte[0];

		/* ʐM */
		private int commCnt = 0;
		/* OʐM */
		private long commTime = Long.MAX_VALUE;
		/* ŒZʐMԊu */
		private long minCommSpan = Long.MAX_VALUE;
		/* ŒʐMԊu */
		private long maxCommSpan = Long.MIN_VALUE;

		public DefineData() {
		}

		public void addCommand(WifeCommand command) {
			commands.add(command);
			oldData = new byte[0]; // Ǎ݃f[^ɕKقB
		}

		public void removeDefine(WifeCommand command) {
			commands.remove(command);
		}

		/*
		 * 
		 */
		public Collection<WifeCommand> getDefines() {
			return new HashSet<WifeCommand>(commands);
		}

		/*
		 * OlƈႢ true
		 */
		public boolean updateData(byte[] data) {
			if (Arrays.equals(oldData, data))
				return false;
			oldData = data;
			return true;
		}

		/*
		 * ʐM񐔋yђʐMԊuXV
		 */
		public void countup() {
			commCnt++;

			long nowTime = System.currentTimeMillis();
			if (commTime < nowTime) {
				long span = nowTime - commTime;
				if (span < minCommSpan) {
					minCommSpan = span;
				}
				if (maxCommSpan < span) {
					maxCommSpan = span;
				}
			}
			commTime = nowTime;
		}

		public String getCountString() {
			StringBuffer sb = new StringBuffer();
			sb.append("Comm Count:").append(commCnt).append("\n");
			sb.append("CommTimeSpan min:").append(minCommSpan / 1000.0);
			sb.append(" max:").append(maxCommSpan / 1000.0).append("\n");
			return sb.toString();
		}
	}
}
