/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.server.command;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.F11.scada.server.alarm.DataValueChangeEventKey;
import org.apache.log4j.Logger;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

/**
 * w肳ꂽpXɃrbgo͂NXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class FileWriteCommand implements Command {
	/** pX */
	private String path;
	/** ݃G[gCԊu */
	private long errorRetryTime = 1000;
	/** ݃G[gC */
	private int errorRetryCount = 1;
	/** Logging API */
	private static Logger log = Logger.getLogger(FileWriteCommand.class);
	/** Xbhv[sNX */
	private static Executor executor = Executors.newCachedThreadPool();

	/**
	 * R}hs܂
	 * @param evt f[^ύXCxg
	 */
	public void execute(DataValueChangeEventKey evt) {
		if (path == null) {
			throw new IllegalStateException("path not setting.");
		}

		try {
			executor.execute(new FileWriteCommandTask(evt));
		} catch (RejectedExecutionException e) {}
	}

	/**
	 * pXݒ肵܂
	 * @param string pX
	 */
	public void setPath(String string) {
		path = string;
	}

	/**
	 * ݃G[gC񐔂ݒ肵܂
	 * @param i ݃G[gC
	 */
	public void setErrorRetryCount(int i) {
		errorRetryCount = i;
	}

	/**
	 * ݃G[gCԊuݒ肵܂B
	 * @param i ݃G[gCԊu
	 */
	public void setErrorRetryTime(int i) {
		errorRetryTime = i;
	}


	/**
	 * Executor Ŏs^XÑNXłB
	 * 
	 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
	 */
	private class FileWriteCommandTask implements Runnable {
		/** f[^ύXCxg̎Q */
		private final DataValueChangeEventKey evt;

		/**
		 * ^XN܂
		 * @param evt f[^ύXCxg
		 */
		FileWriteCommandTask(DataValueChangeEventKey evt) {
			this.evt = evt;
		}

		/**
		 * Executor ɂs郁\bhłB
		 */
		public void run() {
			PrintWriter out = null;
			for (int i = 1; i <= errorRetryCount; i++) {
				try {
					out = new PrintWriter(new BufferedWriter(new FileWriter(path)));
					if (evt.getValue().booleanValue()) {
						out.write("1");
					} else {
						out.write("0");
					}
					break;
				} catch (IOException e) {
					log.error(
						"݃G[܂B"
							+ errorRetryTime
							+ "~bɃgC܂B ("
							+ i
							+ "/"
							+ errorRetryCount
							+ ")");
					sleep(errorRetryTime);
					continue;
				} finally {
					if (out != null) {
						out.close();
					}
				}
			}
		}
	
		private void sleep(long l) {
			try {
				Thread.sleep(l);
			} catch (InterruptedException e) {}
		}
	}
}
