/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/server/alarm/table/AlarmTableModel.java,v 1.5.2.2 2006/08/16 08:53:06 frdm Exp $
 * $Revision: 1.5.2.2 $
 * $Date: 2006/08/16 08:53:06 $
 *
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.server.alarm.table;

import java.util.SortedMap;

import javax.swing.table.TableModel;

import org.F11.scada.server.alarm.AlarmTableJournal;
import org.F11.scada.server.alarm.DataValueChangeEventKey;
import org.F11.scada.xwife.applet.alarm.event.CheckEvent;
import org.F11.scada.xwife.applet.alarm.event.CheckTable;

/**
 * xEԃe[uf̃C^[tFCXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public interface AlarmTableModel extends TableModel, CheckTable {
	/**
	 * Ŏw肵^CX^v傫W[if[^̃XgԂ܂B
	 * @param t ^CX^vLongl
	 * @return SortedMap W[if[^̃}bv
	 */
	public SortedMap<Long, AlarmTableJournal> getAlarmJournal(long t);

	/**
	 * w肵sEJɃf[^ݒ肵܂B̌W[if[^ǉ܂B
	 * @param data ݒ肷f[^̔z
	 * @param rowIndex f[^ݒ肷s
	 * @param columnIndex f[^ݒ肷J
	 * @param key f[^ύXCxgl
	 */
	public void setValueAt(
			Object[] data,
			int rowIndex,
			int columnIndex,
			DataValueChangeEventKey key);

	/**
	 * w肵sɃf[^}܂B̌W[if[^ǉ܂B
	 * @param row f[^}s
	 * @param data }f[^̔z
	 * @param key f[^ύXCxgl
	 */
	public void insertRow(int row, Object[] data, DataValueChangeEventKey key);

	/**
	 * w肵s̃f[^폜܂B̌W[if[^ǉ܂B
	 * @param row 폜s
	 * @param key f[^ύXCxgl
	 */
	public void removeRow(int row, DataValueChangeEventKey key);

	/**
	 * W[if[^̃Xge[ufɔfAW[if[^ɒǉ܂B
	 * @param value W[if[^̃\[g}bv
	 */
	public void setValue(SortedMap<Long, AlarmTableJournal> value);

	/**
	 * Ō̃W[if[^Ԃ܂B
	 * @return Ō̃W[if[^
	 */
	public AlarmTableJournal getLastJournal();

	/**
	 * L[܂ލŏ̍sԂ܂B
	 * @param key f[^ύXCxglL[IuWFNg
	 * @return int L[̍s݂ꍇ́A̍sԂ܂B݂Ȃꍇ͕(-1)Ԃ܂B
	 */
	public int searchRow(DataValueChangeEventKey key);

	/**
	 * w肵sɃf[^}܂B
	 * @param row f[^}s
	 * @param data }f[^̔z
	 */
	public void insertRow(int row, Object[] data);

	/**
	 * xύXǉ܂
	 * @param aj xύX
	 */
	void setJournal(AlarmTableJournal aj);

	/**
	 * Ŏw肵^CX^v傫mFCxgW[if[^̃XgԂ܂B
	 * @param t ^CX^vLongl
	 * @return SortedMap mFCxgW[if[^̃}bv
	 */
	SortedMap<Long, CheckEvent> getCheckJournal(long t);

	/**
	 * Ō̌xmFW[if[^Ԃ܂B
	 * @return Ō̌xmFW[if[^
	 */
	CheckEvent getLastCheckEvent();

	/**
	 * sƗ񖼂e[u̒lo܂B
	 * @param row s
	 * @param columnName J
	 * @return lIuWFNg
	 */
	Object getValueAt(int row, String columnName);

	/**
	 * J񐔂Ԃ܂B
	 * @param columnName J
	 * @return 
	 */
	int getColumn(String columnName);


	/**
	 * w肵s̃f[^폜܂B
	 * @param row 폜s
	 */
	void removeRow(int row);
}
