/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

package org.F11.scada.server.alarm.print;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;

import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.Manager;

import org.F11.scada.EnvironmentManager;
import org.F11.scada.Service;
import org.F11.scada.data.WifeDataDigital;
import org.F11.scada.server.alarm.AlarmDataStore;
import org.F11.scada.server.alarm.DataValueChangeEventKey;
import org.apache.log4j.Logger;

public abstract class AbstractPrintService implements AlarmDataStore, Runnable,
		Service {
	/** xf[^x[XDAO */
	protected final AlarmPrintDAO printDAO;
	/** f[^Xg */
	protected List<PrintLineData> printLineDatas;
	/** CxgL[ */
	protected final BlockingQueue<DataValueChangeEventKey> queue;
	/** Xbh */
	protected Thread thread;
	/** v^[NX */
	protected final AlarmPrinter printer;
	/** bNIuWFNg */
	protected final ReentrantLock lock = new ReentrantLock();
	/** xbZ[W̕\tO */
	private boolean isWarning = true;
	/** MOAPI */
	private static Logger log = Logger.getLogger(AbstractPrintService.class);

	protected AbstractPrintService(AlarmPrintDAO printDAO, AlarmPrinter printer) {
		this.printDAO = printDAO;
		queue = new LinkedBlockingQueue<DataValueChangeEventKey>();
		this.printer = printer;
	}

	/**
	 * f[^ύXCxgl𓊓܂B
	 * 
	 * @param key f[^ύXCxgl
	 */
	public void put(DataValueChangeEventKey key) {
		try {
			if (isPrint()) {
				queue.put(key);
			}
		} catch (InterruptedException e) {
			log.info("荞݂܂", e);
		}
	}

	private boolean isPrint() {
		String dataHolderID =
			EnvironmentManager.get("/server/alarm/print/enable", "");
		if (null == dataHolderID || "".equals(dataHolderID)) {
			if (isWarning) {
				log.info("󎚐ݒz_ݒ肳Ă܂BɈ󎚂܂");
				isWarning = false;
			}
			return true;
		} else {
			DataHolder hd = Manager.getInstance().findDataHolder(dataHolderID);
			if (hd == null) {
				if (isWarning) {
					log.info("󎚐ݒz_ݒ肳Ă܂BɈ󎚂܂");
					isWarning = false;
				}
				return true;
			} else {
				Object obj = hd.getValue();
				if (WifeDataDigital.class.isInstance(obj)) {
					WifeDataDigital d = (WifeDataDigital) obj;
					return d.isOnOff(true);
				} else {
					if (isWarning) {
						log.info("󎚐ݒz_fW^^Cvł͂܂BɈ󎚂܂");
						isWarning = false;
					}
					return true;
				}
			}
		}
	}

	/**
	 * L[f[^ύXCxgoAf[^Xgɒǉf[^x[XɒǉB
	 */
	public void run() {
		Thread ct = Thread.currentThread();
		while (ct == thread) {
			try {
				insertEvent(queue.take());
			} catch (InterruptedException e) {
				log.info("荞݂܂", e);
			}
		}
	}

	/**
	 * f[^ύXCxgf[^x[XƃXgɒǉ܂ ̃\bh public ɂȂĂ̂́AAcpect
	 * ɂgUNV\ɂׂłB
	 * 
	 * @param key f[^ύXCxg
	 */
	abstract public void insertEvent(DataValueChangeEventKey key);

	/**
	 * T[o[XbhJn܂B
	 */
	public void start() {
		if (thread == null) {
			thread = new Thread(this);
			thread.setName(getClass().getName());
			thread.start();
		}
	}

	/**
	 * T[o[Xbh~܂B
	 */
	public void stop() {
		if (thread != null) {
			Thread th = thread;
			thread = null;
			th.interrupt();
		}
	}
}
