package org.F11.scada.security;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

import org.F11.scada.security.auth.Subject;

/**
 * WIFE ̃ANZX䔻NX́A[g\bhĂяoC^[tFCXłB
 * TuNXŃ\[X̃ANZXFƁA[U[F؂܂B
 */
public interface AccessControlable extends Remote {
	/*
	 * \[X̃ANZXFs܂B
	 * w肵 Subject  permission Ŏw肳ꂽANZXAĂ邩肵܂B
	 * @param subject Subject
	 * @param permission ANZX
	 * @return Ăꍇ trueAłȂꍇ false Ԃ܂B
	 * @throws RemoteException RMI ĂяoɎsꍇ
	public boolean checkPermission(Subject subject, WifePermission permission)
			throws RemoteException;
	 */

	/**
	 * SĂ̕ҏW\V{\[X̃ANZXFs܂B
	 * w肵 Subject  destinations Ŏw肳ꂽANZXAĂ邩肵܂B
	 * @param subject Subject
	 * @param destinations ҏW\V{ێĂf[^z_[̔z
	 * @return Ăꍇ trueAłȂꍇ false  Booleanz̃XgԂ܂B
	 * @throws RemoteException RMI ĂяoɎsꍇ
	 */
	public List checkPermission(Subject subject, String[][] destinations)
			throws RemoteException;

	/**
	 * [U[̔F؂s܂B
	 * F؂ꍇAF؂[U[̃vVp֘AÂ Subject Ԃ܂B
	 * F؂Ɏsꍇ null Ԃ܂B
	 * @param user F؂郆[U[
	 * @param password F؂郆[U[̈ÍꂽpX[h
	 * @return F؂ꍇAF؂[U[̃vVp֘AÂ Subject Ԃ܂B
	 * F؂Ɏsꍇ null Ԃ܂B
	 * @throws RemoteException RMI ĂяoɎsꍇ
	 */
	public Subject checkAuthentication(String user, String password)
			throws RemoteException;
	
	/**
	 * NCAgIPAhX烍OAEg̃[U擾܂B
	 * @param local NCAgIPAhX
	 * @return OAEg̃[U
	 * @throws RemoteException
	 */
	public String getLogoutUser(InetAddress local) throws RemoteException;
}
