package org.F11.scada.scheduling;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.Logger;

/**
 *  莞ԂXPW[ECe[^[NXł
 */
public class MonthlyIterator implements ScheduleIterator {
	/** ̓vZJ_[ */
	private final Calendar calendar = Calendar.getInstance();
	/** Logging API */
	private static Logger log = Logger.getLogger(MonthlyIterator.class);
	/** tH[}b^[ */
	private final DateFormat fmt = DateFormat.getDateTimeInstance();

	/**
	 * t͓gpEEEbw肵āACe[^[܂B
	 * tɂ1`28w肵܂
	 *
	 * @param day 
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 */
	public MonthlyIterator(int day, int hourOfDay, int minute, int second) {
		this(day, hourOfDay, minute, second, new Date());
	}

	/**
	 * tEEEEbw肵āACe[^[܂B
	 * tIuWFNg̓EEEb͈̎EEbŏ㏑܂
	 * tɂ1`28w肵܂
	 *
	 * @param day 
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 * @param date t
	 */
	public MonthlyIterator(int day, int hourOfDay, int minute, int second, Date date) {
		if (day < 1 || day > 28) {
			throw new IllegalArgumentException("Please specify even 1-28 to be the dates.");
		}
		calendar.setLenient(false);
		calendar.setTime(date);
		calendar.set(Calendar.DATE, day);
		calendar.set(Calendar.HOUR_OF_DAY, hourOfDay);
		calendar.set(Calendar.MINUTE, minute);
		calendar.set(Calendar.SECOND, second);
		calendar.set(Calendar.MILLISECOND, 0);
		if (!calendar.getTime().before(date)) {
			calendar.add(Calendar.MONTH, -1);
		}
	}

	/**
	 * ɎsԂ܂B
	 * @return ɎsԂ܂B
	 */
	public Date next() {
		calendar.add(Calendar.MONTH, 1);
		if (log.isInfoEnabled()) {
			log.info("Next schedule date : " + fmt.format(calendar.getTime()));
		}
		return calendar.getTime();
	}

}
