/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.ngraph.model;


import java.beans.PropertyChangeListener;
import java.util.List;

import org.F11.scada.applet.ngraph.SeriesGroup;


/**
 * Otf
 *
 * @author maekawa
 *
 */
public interface GraphModel {
	/** fꂽƂɒʒm܂ */
	final static String INITIALIZE = GraphModel.class.getName() + ".initialize";
	/** f̃f[^lύXꂽƂɒʒm܂ */
	final static String VALUE_CHANGE =
		GraphModel.class.getName() + ".value.change";
	/** JgO[vύXꂽƂɒʒm܂ */
	final static String GROUP_CHANGE =
		GraphModel.class.getName() + ".group.change";

	/**
	 * f̃vpeBύXXi[o^܂
	 *
	 * @param listener vpeBύXXi[
	 */
	void addPropertyChangeListener(PropertyChangeListener listener);

	/**
	 * f̃vpeBύXXi[폜܂
	 *
	 * @param listener vpeBύXXi[
	 */
	void removePropertyChangeListener(PropertyChangeListener listener);

	/**
	 * f܂B
	 */
	void initialize();

	/**
	 * fI܂B
	 */
	void shutdown();

	/**
	 * fێf[^R[hԂ܂
	 *
	 * @return fێf[^R[hԂ܂
	 */
	int getMaxRecord();

	/**
	 * O[vݒ肵Af̓eΏۃO[vɕύX܂B
	 *
	 * @param group ΏۃO[v
	 */
	void setGroupNo(int group);

	/**
	 * JgO[vNo.Ԃ܂B
	 *
	 * @return O[vNoԂ܂B
	 */
	int getGroupNo();

	/**
	 * JgO[vԂ܂B
	 *
	 * @return JgO[vԂ܂
	 */
	String getGroupName();

	/**
	 * O[ṽXgԂ܂B
	 *
	 * @return O[ṽXgԂ܂B
	 */
	List<SeriesGroup> getSeriesGroups();

	/**
	 * f[^擾ΏۃOԂ܂
	 *
	 * @return f[^擾ΏۃOԂ܂
	 */
	String getLogName();

	/**
	 * f[^擾ΏۃOݒ肵܂
	 *
	 * @param logName f[^擾ΏۃOݒ肵܂
	 */
	void setLogName(String logName);

	/**
	 * XN[o[ŏlɂȂꍇʒm܂B
	 * @return TODO
	 */
	boolean reachedMinimum();

	/**
	 * XN[o[őlɂȂꍇʒm܂B
	 * @return TODO
	 */
	boolean reachedMaximum();

	/**
	 * vpeBύXXi[Sď܂B
	 */
	void removePropertyChangeListeners();

}