package org.F11.scada.applet.graph;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;

import org.F11.scada.WifeUtilities;
import org.F11.scada.applet.ClientConfiguration;

/**
 * O[v{^̃Xi[NXłB tH[hAobNAꗗI3̃ANVXi[𐶐܂B new
 * ŃCX^XłȂ̂ŁA3ʂ̃t@Ng\bhŃC^XĉB
 */
public class GroupButtonListener implements ActionListener {
	/** OtvpeBf */
	private GraphPropertyModel graphPropertyModel;

	/** O[vIuWFNg */
	private GroupAction groupAction;

	/**
	 * vCx[gRXgN^ new ŃCX^XłȂ̂ŁA3ʂ̃t@Ng\bhŃC^XĉB
	 * 
	 * @param graphPropertyModel OtvpeBf
	 * @param groupAction O[vIuWFNg
	 */
	private GroupButtonListener(
			GraphPropertyModel graphPropertyModel,
			GroupAction groupAction) {
		this.graphPropertyModel = graphPropertyModel;
		this.groupAction = groupAction;
	}

	/**
	 * {^̉̃ANVCxg
	 * 
	 * @param evt ActionEvent
	 */
	public void actionPerformed(ActionEvent evt) {
		JComponent component = (JComponent) evt.getSource();
		groupAction.groupAction(graphPropertyModel, component);
	}

	/**
	 * O[vtH[h̃ANVXi[𐶐܂B
	 * 
	 * @param graphPropertyModel OtvpeBf
	 * @return GroupButtonListener
	 */
	public static GroupButtonListener createForwardListener(
			GraphPropertyModel graphPropertyModel) {
		return new GroupButtonListener(graphPropertyModel, GroupAction.FORWARD);
	}

	/**
	 * O[vobÑANVXi[𐶐܂B
	 * 
	 * @param graphPropertyModel OtvpeBf
	 * @return GroupButtonListener
	 */
	public static GroupButtonListener createBackListener(
			GraphPropertyModel graphPropertyModel) {
		return new GroupButtonListener(graphPropertyModel, GroupAction.BACK);
	}

	/**
	 * O[vꗗĨANVXi[𐶐܂B
	 * 
	 * @param graphPropertyModel OtvpeBf
	 * @return GroupButtonListener
	 */
	public static GroupButtonListener createDialogListener(
			GraphPropertyModel graphPropertyModel) {
		return new GroupButtonListener(graphPropertyModel, GroupAction.DIALOG);
	}

	/**
	 * O[vANṼ^CvZ[t enum NXłB tH[hAobNAꗗI|tH[Yŏ܂B new
	 * ŃCX^Xł܂B\߃CX^XÓItB[hgpĉB
	 */
	private abstract static class GroupAction {
		/**
		 * vCx[gRXgN^
		 */
		private GroupAction() {
		}

		/**
		 * O[ṽANVۂɏ鉼z\bhB ̐ÓItB[hCX^XɁAANV܂B
		 * 
		 * @param graphPropertyModel OtvpeBf
		 * @param component eR|[lg
		 */
		abstract void groupAction(
				GraphPropertyModel graphPropertyModel,
				JComponent component);

		/** tH[hANV */
		static GroupAction FORWARD = new GroupAction() {
			void groupAction(
					GraphPropertyModel graphPropertyModel,
					JComponent component) {
				graphPropertyModel.nextGroup();
			}
		};

		/** obNANV */
		static GroupAction BACK = new GroupAction() {
			void groupAction(
					GraphPropertyModel graphPropertyModel,
					JComponent component) {
				// obN
				graphPropertyModel.prevGroup();
			}
		};

		/** ꗗIANV */
		static GroupAction DIALOG = new GroupAction() {
			void groupAction(
					GraphPropertyModel graphPropertyModel,
					JComponent component) {
				// ꗗ_CAO
				Frame frame = WifeUtilities.getParentFrame(component);
				new GroupSelectDialog(frame, graphPropertyModel);
			}
		};
	}

	/**
	 * O[vI_CAONXłB
	 */
	private static class GroupSelectDialog extends JDialog {
		private static final long serialVersionUID = 4329010424946405060L;

		private GraphPropertyModel graphPropertyModel;

		private JList list;

		private JButton okButton;

		private JButton cancelButton;

		private Window window;

		GroupSelectDialog(Frame frame, GraphPropertyModel graphPropertyModel) {
			super(frame, "O[vI", true);
			this.graphPropertyModel = graphPropertyModel;
			this.window = frame;
			init();
		}

		private void init() {
			setDefaultCloseOperation(DISPOSE_ON_CLOSE);
			list = new JList(graphPropertyModel.getGroupNames().toArray());
			list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			list.setSelectedIndex(graphPropertyModel.getGroup());
			JScrollPane scpane = new JScrollPane(list);
			JViewport p = scpane.getViewport();
			p.setViewPosition(new Point(0, graphPropertyModel.getGroup()
				* scpane.getVerticalScrollBar().getBlockIncrement(1)));
			okButton = new JButton("OK");
			cancelButton = new JButton("CANCEL");

			okButton.addActionListener(new OkButtonListener(this));
			cancelButton.addActionListener(new CancelButtonListener(this));

			JPanel buttonPanel = new JPanel();
			buttonPanel.add(okButton);
			buttonPanel.add(cancelButton);

			Container cont = getContentPane();
			cont.add(scpane, BorderLayout.CENTER);
			cont.add(buttonPanel, BorderLayout.SOUTH);

			list.addMouseListener(new ListListener(this));

			setSize();

			Dimension fDimension = window.getSize();
			Dimension dDimension = getSize();
			Point location = window.getLocation();
			location.translate(
				(fDimension.width - dDimension.width) / 2,
				(fDimension.height - dDimension.height) / 2);
			setLocation(location);

			show();
		}

		private void setSize() {
			ClientConfiguration configuration = new ClientConfiguration();
			setSize(configuration.getInt(
				"xwife.applet.Applet.trend.dialog.width",
				157), configuration.getInt(
				"xwife.applet.Applet.trend.dialog.height",
				217));
		}

		private static class OkButtonListener implements ActionListener {
			private GroupSelectDialog groupSelectDialog;

			OkButtonListener(GroupSelectDialog groupSelectDialog) {
				this.groupSelectDialog = groupSelectDialog;
			}

			public void actionPerformed(ActionEvent evt) {
				int group = groupSelectDialog.list.getSelectedIndex();
				if (JListUtil.hasSelected(groupSelectDialog, group)) {
					groupSelectDialog.graphPropertyModel.setGroup(group);
					groupSelectDialog.dispose();
				}
			}
		}

		private static class CancelButtonListener implements ActionListener {
			private GroupSelectDialog groupSelectDialog;

			CancelButtonListener(GroupSelectDialog groupSelectDialog) {
				this.groupSelectDialog = groupSelectDialog;
			}

			public void actionPerformed(ActionEvent evt) {
				this.groupSelectDialog.dispose();
			}
		}

		private static class ListListener extends MouseAdapter {
			private GroupSelectDialog groupSelectDialog;

			ListListener(GroupSelectDialog groupSelectDialog) {
				this.groupSelectDialog = groupSelectDialog;
			}

			public void mouseReleased(MouseEvent e) {
				if (e.getClickCount() == 2) {
					int group =
						groupSelectDialog.list.locationToIndex(e.getPoint());
					groupSelectDialog.graphPropertyModel.setGroup(group);
					groupSelectDialog.dispose();
				}
			}
		}
	}
}
