/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.applet.graph;

import java.sql.Timestamp;
import java.util.Arrays;

import org.apache.commons.lang.ArrayUtils;

/**
 * GraphSeriesProperty ̎NXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class GraphSeriesProperty {

	/** V[ỸTCYiO[ṽV[Yj */
	private int seriesSize;
	/** cXP[̍ŏlz */
	private double[] verticalMinimums;
	/** cXP[̍őlz */
	private double[] verticalMaximums;
	/** cXP[̍ŏ͒lz */
	private double[] verticalInputMinimums;
	/** cXP[̍ő͒lz */
	private double[] verticalInputMaximums;
	/** f[^voC_z */
	private String[] dataProviderNames;
	/** f[^z_z */
	private String[] dataHolderNames;
	/** QƒlNX̔z */
	private GraphFoldProperty[] referenceValues;
	/** V[Y(O[v) */
	private String seriesName;
	/** |Cĝ̔z */
	private String[] pointNames;
	/** |CgL̔z */
	private String[] pointMarks;
	/** ݒl\V{ */
	private transient ExplanatoryNotesText[] symbols;

	/**
	 * RXgN^
	 * ܂ԂΉo[W
	 */
	public GraphSeriesProperty(
		int seriesSize,
		double[] verticalMinimums,
		double[] verticalMaximums,
		double[] verticalInputMinimums,
		double[] verticalInputMaximums,
		String[] dataProviderNames,
		String[] dataHolderNames,
		int foldCount,
		String seriesName,
		String[] pointNames,
		String[] pointMarks,
		ExplanatoryNotesText[] symbols) {

		this.seriesSize = seriesSize;
		this.verticalMinimums = verticalMinimums;
		this.verticalMaximums = verticalMaximums;
		this.verticalInputMinimums = verticalInputMinimums;
		this.verticalInputMaximums = verticalInputMaximums;
		this.dataProviderNames = dataProviderNames;
		this.dataHolderNames = dataHolderNames;
		this.referenceValues = new GraphFoldProperty[seriesSize];
		for (int i = 0; i < referenceValues.length; i++) {
			referenceValues[i] = new GraphFoldProperty(foldCount);
		}
		this.seriesName = seriesName;
		this.pointNames = pointNames;
		this.pointMarks = pointMarks;
		this.symbols = symbols;
	}

	/**
	 * RXgN^
	 */
	public GraphSeriesProperty(
		int seriesSize,
		Double[] verticalMinimums,
		Double[] verticalMaximums,
		Double[] verticalInputMinimums,
		Double[] verticalInputMaximums,
		String[] dataProviderNames,
		String[] dataHolderNames,
		int foldCount,
		String seriesName,
		String[] pointNames,
		String[] pointMarks,
		ExplanatoryNotesText[] symbols) {
		this(
			seriesSize,
			toPrimitiveArray(verticalMinimums),
			toPrimitiveArray(verticalMaximums),
			toPrimitiveArray(verticalInputMinimums),
			toPrimitiveArray(verticalInputMaximums),
			dataProviderNames,
			dataHolderNames,
			foldCount,
			seriesName,
			pointNames,
			pointMarks,
			symbols);
	}

	private static double[] toPrimitiveArray(Double[] array) {
		double[] retValue = new double[array.length];
		for (int i = 0; i < array.length; i++) {
			retValue[i] = array[i].doubleValue();
		}
		return retValue;
	}

	/**
	 * Rs[RXgN^
	 * @param src Rs[ GraphSeriesProperty IuWFNg
	 */
	public GraphSeriesProperty(GraphSeriesProperty src) {
		seriesSize = src.seriesSize;
		verticalMinimums = new double[src.verticalMinimums.length];
		System.arraycopy(
			src.verticalMinimums,
			0,
			verticalMinimums,
			0,
			verticalMinimums.length);
		verticalMaximums = new double[src.verticalMaximums.length];
		System.arraycopy(
			src.verticalMaximums,
			0,
			verticalMaximums,
			0,
			verticalMaximums.length);
		verticalInputMinimums = new double[src.verticalInputMinimums.length];
		System.arraycopy(
			src.verticalInputMinimums,
			0,
			verticalInputMinimums,
			0,
			verticalInputMinimums.length);
		verticalInputMaximums = new double[src.verticalInputMaximums.length];
		System.arraycopy(
			src.verticalInputMaximums,
			0,
			verticalInputMaximums,
			0,
			verticalInputMaximums.length);
		dataProviderNames = new String[src.dataProviderNames.length];
		System.arraycopy(
			src.dataProviderNames,
			0,
			dataProviderNames,
			0,
			dataProviderNames.length);
		dataHolderNames = new String[src.dataHolderNames.length];
		System.arraycopy(
			src.dataHolderNames,
			0,
			dataHolderNames,
			0,
			dataHolderNames.length);
		referenceValues = new GraphFoldProperty[src.referenceValues.length];
		for (int i = 0; i < src.referenceValues.length; i++) {
			referenceValues[i] = new GraphFoldProperty(src.referenceValues[i]);
		}
		seriesName = src.seriesName;
		pointNames = new String[src.pointNames.length];
		System.arraycopy(src.pointNames, 0, pointNames, 0, pointNames.length);
		pointMarks = new String[src.pointMarks.length];
		System.arraycopy(src.pointMarks, 0, pointMarks, 0, pointMarks.length);
		symbols = new ExplanatoryNotesText[src.symbols.length];
		System.arraycopy(src.symbols, 0, symbols, 0, symbols.length);
	}

	/**
	 * ݒ肳ĂV[ỸTCYԂ܂B
	 * @return ݒ肳ĂV[ỸTCYiO[ṽV[Yj
	 */
	public int getSeriesSize() {
		return seriesSize;
	}

	/**
	 * cXP[̍ŏlԂ܂B
	 * @param series V[Y
	 * @return cXP[̍ŏl
	 */
	public double getVerticalMinimum(int series) {
		return isValidSeries(series) ? verticalMinimums[series] : 0;
	}

	/**
	 * cXP[̍őlԂ܂B
	 * @param series V[Y
	 * @return cXP[̍ől
	 */
	public double getVerticalMaximum(int series) {
		return isValidSeries(series) ? verticalMaximums[series] : 0;
	}

	/**
	 * ݈ʒuÂĂO[v́AcXP[͍̓ŏlԂ܂B
	 * @param series V[Y
	 * @return cXP[͍̓ŏl
	 */
	public double getVerticalInputMinimum(int series) {
		return isValidSeries(series) ? verticalInputMinimums[series] : 0;
	}

	/**
	 * ݈ʒuÂĂO[v́AcXP[͍̓őlԂ܂B
	 * @param series V[Y
	 * @return cXP[͍̓ől
	 */
	public double getVerticalInputMaximum(int series) {
		return isValidSeries(series) ? verticalInputMaximums[series] : 0;
	}

	/**
	 * cXP[̍ŏlݒ肵܂B
	 * @param series V[Y
	 * @param verticalMinimum cXP[̍ŏl
	 */
	public void setVerticalMinimum(int series, double verticalMinimum) {
		checkArgument(series);
		this.verticalMinimums[series] = verticalMinimum;
	}

	/**
	 * cXP[̍őlݒ肵܂B
	 * @param series V[Y
	 * @param verticalMaximum cXP[̍ől
	 */
	public void setVerticalMaximum(int series, double verticalMaximum) {
		checkArgument(series);
		this.verticalMaximums[series] = verticalMaximum;
	}

	private void checkArgument(double argv) {
		if (argv < 0 || argv >= seriesSize) {
			StringBuffer buffer = new StringBuffer();
			buffer.append("Series size not equal argv : argv = ");
			buffer.append(argv);
			buffer.append(" seriesSize = ");
			buffer.append(seriesSize);
			throw new IllegalArgumentException(buffer.toString());
		}
	}

	/**
	 * f[^voC_Ԃ܂B
	 * @param series V[Y
	 * @return f[^voC_
	 */
	public String getDataProviderName(int series) {
		return isValidSeries(series) ? dataProviderNames[series] : "";
	}

	/**
	 * f[^z_Ԃ܂B
	 * @param series V[Y
	 * @return f[^z_
	 */
	public String getDataHolderName(int series) {
		return isValidSeries(series) ? dataHolderNames[series] : "";
	}

	/**
	 * ݈ʒuÂĂO[v́AQƒlԂ܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @return Qƒl
	 */
	public double getReferenceValue(int series, int fold) {
		return isValidSeries(series) ? referenceValues[series].getReferenceValue(fold) : 0;
	}

	/**
	 * ݈ʒuÂĂO[v́AQƒlݒ肵܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @param referenceValue Qƒl
	 */
	public void setReferenceValue(int series, int fold, double referenceValue) {
		checkArgument(series);
		this.referenceValues[series].setReferenceValue(fold, referenceValue);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƎԂ܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @return QƎ
	 */
	public Timestamp getReferenceTime(int series, int fold) {
		return isValidSeries(series) ? referenceValues[series].getReferenceTime(fold) : new Timestamp(0);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƎݒ肵܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @param referenceTime QƎ
	 */
	public void setReferenceTime(int series, int fold, Timestamp referenceTime) {
		checkArgument(series);
		this.referenceValues[series].setReferenceTime(fold, referenceTime);
	}
	
	/**
	 * ̃V[Y̖(O[v)Ԃ܂B
	 * @return ̃V[Y̖(O[v)Ԃ܂B
	 */
	public String getSeriesName() {
		return seriesName;
	}
	
	/**
	 * f[^z_[Ɋ֘AÂꂽ̂Ԃ܂B
	 * @param series V[Y
	 * @return f[^z_[Ɋ֘AÂꂽ̂Ԃ܂B
	 */
	public String getPointName(int series) {
		return isValidSeries(series) ? pointNames[series] : "";
	}
	
	/**
	 * f[^z_[Ɋ֘AÂꂽPʋLԂ܂B
	 * @param series V[Y
	 * @return f[^z_[Ɋ֘AÂꂽPʋLԂ܂B
	 */
	public String getPointMark(int series) {
		return isValidSeries(series) ? pointMarks[series] : "";
	}
	
	/**
	 * ݒl̃AiOV{Ԃ܂B
	 * @param series V[Y
	 * @return ݒl̃AiOV{Ԃ܂B
	 */
	public ExplanatoryNotesText getSymbol(int series) {
		return isValidSeries(series) ? symbols[series] : null;
	}
	

	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 * vpeB𕶎\ĕԂ܂BÃ\bh͊JiKŎgpׂłA
	 * eXgړIȊOŎgpȂłBAԂeύX邱Ƃ܂B
	 * @return IuWFNg̕\
	 */
	public String toString() {
		StringBuffer b = new StringBuffer();

		b.append("seriesSize=").append(seriesSize)
		.append(",verticalMinimums=").append(ArrayUtils.toObject(verticalMinimums))
		.append(",verticalMaximums=").append(ArrayUtils.toObject(verticalMaximums))
		.append(",verticalInputMinimums=").append(ArrayUtils.toObject(verticalInputMinimums))
		.append(",verticalInputMaximums=").append(ArrayUtils.toObject(verticalInputMaximums))
		.append(",dataProviderNames=").append(Arrays.asList(dataProviderNames))
		.append(",dataHolderNames=").append(Arrays.asList(dataHolderNames))
		.append(",referenceValues=").append(Arrays.asList(referenceValues))
		.append(",seriesName=").append(seriesName)
		.append(",pointNames=").append(Arrays.asList(pointNames))
		.append(",pointMarks=").append(Arrays.asList(pointMarks));
		
		return b.toString();
	}

	/**
	 * ʂ̃IuWFNgÃIuWFNgƓׂ܂B
	 * ʂ͈ null łȂÃIuWFNgƓevpeB[itB[hj̒l
	 * IuWFNgłꍇ true Ԃ܂B
	 * @param obj  GraphSeriesProperty Ɠǂ肳IuWFNg
	 * @return IuWFNgłꍇ trueAłȂꍇ false
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof GraphSeriesProperty)) {
			return false;
		}
		GraphSeriesProperty gp = (GraphSeriesProperty) obj;

		return gp.seriesSize == seriesSize
			&& Arrays.equals(gp.verticalMinimums, verticalMinimums)
			&& Arrays.equals(gp.verticalMaximums, verticalMaximums)
			&& Arrays.equals(gp.verticalInputMinimums, verticalInputMinimums)
			&& Arrays.equals(gp.verticalInputMaximums, verticalInputMaximums)
			&& Arrays.equals(gp.dataProviderNames, dataProviderNames)
			&& Arrays.equals(gp.dataHolderNames, dataHolderNames)
			&& Arrays.equals(gp.referenceValues, referenceValues)
			&& gp.seriesName.equals(seriesName)
			&& Arrays.equals(gp.pointNames, pointNames)
			&& Arrays.equals(gp.pointMarks, pointMarks);
	}

	/**
	 *  GraphSeriesProperty ̃nbVR[hvZ܂B
	 * @return  GraphSeriesProperty ̃nbVR[hl
	 */
	public int hashCode() {
		int result = 17;
		result = 37 * result + seriesSize;
		result = doubleHashCode(result, verticalMinimums);
		result = doubleHashCode(result, verticalMaximums);
		result = doubleHashCode(result, verticalInputMinimums);
		result = doubleHashCode(result, verticalInputMaximums);
		result = stringHashCode(result, dataProviderNames);
		result = stringHashCode(result, dataHolderNames);
		for (int i = 0, cnt = referenceValues.length; i < cnt; i++) {
			result = 37 * result + referenceValues[i].hashCode();
		}
		result = 37 * result + seriesName.hashCode();
		result = stringHashCode(result, pointNames);
		result = stringHashCode(result, pointMarks);

		return result;
	}
	
	private int doubleHashCode(int result, double[] src) {
		int rt = result;
		for (int i = 0; i < src.length; i++) {
			long dl = Double.doubleToLongBits(src[i]);
			rt = 37 * rt + (int) (dl ^ (dl >>> 32));
		}
		
		return rt;
	}
	
	private int stringHashCode(int result, String[] src) {
		int rt = result;
		for (int i = 0; i < src.length; i++) {
			rt = 37 * rt + src[i].hashCode();
		}
			
		return rt;
	}
	
	private boolean isValidSeries(int series) {
		return (series < 0 || series >= getSeriesSize()) ? false : true;
	}

	/**
	 * QƒlێNXłB
	 * ܂Ԃf[^iQƎ̈Ⴄf[^jT|[g܂B
	 * @author hori <hori@users.sourceforge.jp>
	 */
	private static class GraphFoldProperty {
		/** ܂Ԃ */
		private int foldCount;
		/** Qƒl */
		private double[] referenceValues;
		/** QƎ */
		private Timestamp[] referenceTimes;

		/**
		 * RXgN^
		 */
		public GraphFoldProperty(int foldCount) {
			this.foldCount = foldCount;
			this.referenceValues = new double[foldCount + 1];
			Arrays.fill(this.referenceValues, 0);
			this.referenceTimes = new Timestamp[foldCount + 1];
			Arrays.fill(this.referenceTimes, new Timestamp(0));
		}

		/**
		 * Rs[RXgN^
		 * @param src Rs[ GraphSeriesProperty IuWFNg
		 */
		public GraphFoldProperty(GraphFoldProperty src) {
			foldCount = src.foldCount;
			referenceValues = new double[src.referenceValues.length];
			System.arraycopy(
				src.referenceValues,
				0,
				referenceValues,
				0,
				referenceValues.length);
			referenceTimes = new Timestamp[src.referenceTimes.length];
			for (int i = 0; i < src.referenceTimes.length; i++) {
				referenceTimes[i] = new Timestamp(src.referenceTimes[i].getTime());
			}
		}

		private void checkArgument(double argv) {
			if (argv < 0 || argv > foldCount) {
				StringBuffer buffer = new StringBuffer();
				buffer.append("FoldCount not equal argv : argv = ");
				buffer.append(argv);
				buffer.append(" foldCount = ");
				buffer.append(foldCount);
				throw new IllegalArgumentException(buffer.toString());
			}
		}

		/**
		 * ܂Ԃʒu̎QƒlԂ܂B
		 * @param fold ܂Ԃʒu
		 * @return Qƒl
		 */
		public double getReferenceValue(int fold) {
			return referenceValues[fold];
		}

		/**
		 * ܂Ԃʒu̎Qƒlݒ肵܂B
		 * @param fold ܂Ԃʒu
		 * @param referenceValue Qƒl
		 */
		public void setReferenceValue(int fold, double referenceValue) {
			checkArgument(fold);
			this.referenceValues[fold] = referenceValue;
		}

		/**
		 * ܂Ԃʒu̎QƎԂ܂B
		 * @param fold ܂Ԃʒu
		 * @return QƎ
		 */
		public Timestamp getReferenceTime(int fold) {
			return referenceTimes[fold];
		}

		/**
		 * ܂Ԃʒu̎Qƒlݒ肵܂B
		 * @param fold ܂Ԃʒu
		 * @param referenceTime QƎ
		 */
		public void setReferenceTime(int fold, Timestamp referenceTime) {
			checkArgument(fold);
			this.referenceTimes[fold] = referenceTime;
		}

		/**
		 * ̃IuWFNg̕\Ԃ܂B
		 * vpeB𕶎\ĕԂ܂BÃ\bh͊JiKŎgpׂłA
		 * eXgړIȊOŎgpȂłBAԂeύX邱Ƃ܂B
		 * @return IuWFNg̕\
		 */
		public String toString() {
			StringBuffer buffer = new StringBuffer();
			buffer.append("foldCount:" + foldCount);
			for (int i = 0; i < referenceValues.length; i++) {
				buffer.append(",referenceValue:" + referenceValues[i]);
			}
			for (int i = 0; i < referenceTimes.length; i++) {
				buffer.append(",referenceTimes:" + referenceTimes[i]);
			}
			return buffer.toString();
		}

		/**
		 * ʂ̃IuWFNgÃIuWFNgƓׂ܂B
		 * ʂ͈ null łȂÃIuWFNgƓevpeB[itB[hj̒l
		 * IuWFNgłꍇ true Ԃ܂B
		 * @param obj  GraphSeriesProperty Ɠǂ肳IuWFNg
		 * @return IuWFNgłꍇ trueAłȂꍇ false
		 */
		public boolean equals(Object obj) {
			if (obj == this) {
				return true;
			}
			if (!(obj instanceof GraphFoldProperty)) {
				return false;
			}
			GraphFoldProperty gfp = (GraphFoldProperty) obj;
			return gfp.foldCount == this.foldCount
				&& Arrays.equals(gfp.referenceValues, this.referenceValues)
				&& Arrays.equals(gfp.referenceTimes, this.referenceTimes);
		}

		/**
		 *  GraphSeriesProperty ̃nbVR[hvZ܂B
		 * @return  GraphSeriesProperty ̃nbVR[hl
		 */
		public int hashCode() {
			int result = 17;
			result = 37 * result + foldCount;
			for (int i = 0; i < referenceValues.length; i++) {
				long dl = Double.doubleToLongBits(referenceValues[i]);
				result = 37 * result + (int) (dl ^ (dl >>> 32));
			}
			for (int i = 0; i < referenceTimes.length; i++) {
				result = 37 * result + referenceTimes[i].hashCode();
			}
			return result;
		}
	}
}
