/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.F11.scada.server.wifi.impl;

import java.util.HashMap;
import java.util.Map;

import org.F11.scada.server.wifi.WiFiTerminalMap;
import org.F11.scada.server.wifi.dto.WiFiTerminal;

/**
 * @author Hideaki Maekawa <frdm@user.sourceforge.jp>
 */
public class WiFiTerminalMapImpl implements WiFiTerminalMap {
    private Map terminalMap;
    
    public WiFiTerminalMapImpl() {
        terminalMap = new HashMap();
    }
    
    public Object put(WiFiTerminal terminal) {
        return put(createId(terminal.getProvier(), terminal.getHolder()), terminal);
    }

    private Object createId(String provider, String holder) {
        return new IdWrapper(provider, holder);
    }
    
    private Object put(Object key, Object value) {
        if (terminalMap.containsKey(key)) {
            throw new IllegalArgumentException("duplicate provider key = " + key);
        }
        return terminalMap.put(key, value);
    }
    
    public WiFiTerminal get(String provider, String holder) {
        return (WiFiTerminal) terminalMap.get(createId(provider, holder));
    }
    
    public boolean containsKey(String provider, String holder) {
        return terminalMap.containsKey(createId(provider, holder));
    }

    static class IdWrapper {
        private final String provider;
        private final String holder;
        
        public IdWrapper(String provider, String holder) {
            this.provider = provider;
            this.holder = holder;
        }
        
        public boolean equals(Object obj) {
            if (obj == this)
                return true;
            if (!(obj instanceof IdWrapper))
                return false;
            IdWrapper id = (IdWrapper) obj;
            return provider.equals(id.provider) && holder.equals(id.holder);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + provider.hashCode();
            result = 37 * result + holder.hashCode();
            return result;
        }

        public String toString() {
            return "provider=" + provider + ", holder=" + holder;
        }
    }
}
