/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.schedule;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

import org.F11.scada.data.WifeDataSchedule;
import org.F11.scada.server.schedule.point.dto.DuplicateSeparateScheduleDto;
import org.F11.scada.server.schedule.point.dto.ScheduleGroupDto;
import org.F11.scada.server.schedule.point.dto.SchedulePointDto;
import org.F11.scada.server.schedule.point.dto.SchedulePointRowDto;
import org.F11.scada.server.schedule.point.dto.ScheduleSearchDto;

/**
 * XPW[̃T[o[T[rX
 * 
 * @author maekawa
 * 
 */
public interface SchedulePointService extends Remote {
	/**
	 * DTOŃXPW[@ꗗ̃R[hԂ܂B
	 * 
	 * @param dto 
	 * @return DTOŃXPW[@ꗗ̃R[hԂ܂B
	 * @throws RemoteException
	 */
	SchedulePointDto getSchedulePoint(ScheduleSearchDto dto)
			throws RemoteException;

	/**
	 * DTOŃXPW[@ꗗ̃R[hԂ܂B
	 * 
	 * @param dto 
	 * @return DTOŃXPW[@ꗗ̃R[hԂ܂B
	 * @throws RemoteException
	 */
	SchedulePointDto getSchedulePointByGroup(ScheduleSearchDto dto)
			throws RemoteException;

	/**
	 * T[rX܂B
	 * 
	 * @throws RemoteException
	 */
	void init() throws RemoteException;

	/**
	 * XPW[O[ṽR[hԂ܂B
	 * 
	 * @return XPW[O[ṽR[hԂ܂B
	 * @throws RemoteException
	 */
	List getScheduleGroup(ScheduleGroupDto dto) throws RemoteException;

	/**
	 * ΏۃXPW[O[vNo.XVAPLC݂̏s܂B
	 * 
	 * @param dto
	 * @return
	 * @throws RemoteException
	 */
	int updateSchedulePoint(SchedulePointRowDto dto) throws RemoteException;

	/**
	 * }X^XPW[ʃXPW[փf[^Rs[܂B
	 * 
	 * @param src Rs[}X^XPW[z_
	 * @param dest Rs[ʃXPW[z_̔z
	 * @throws RemoteException
	 * @deprecated {@link duplicateSeparateSchedule(DuplicateSeparateScheduleDto)}gpĂB
	 */
	void duplicateSeparateSchedule(
			ScheduleGroupDto src,
			SchedulePointRowDto[] dest) throws RemoteException;

	/**
	 * }X^XPW[ʃXPW[փf[^Rs[܂B
	 * 
	 * @param dto XPW[Rs[IuWFNg
	 * @throws RemoteException
	 */
	void duplicateSeparateSchedule(DuplicateSeparateScheduleDto dto)
			throws RemoteException;

	/**
	 * ʃXPW[(XPW[)lԂ܂B
	 * 
	 * @param dto z_̐ݒ肳ꂽsf[^
	 * @return ʃXPW[(XPW[)lԂ܂B
	 */
	WifeDataSchedule getSeparateSchedule(SchedulePointRowDto dto)
			throws RemoteException;

	/**
	 * ʃXPW[lXV܂B
	 * 
	 * @param dto z_̐ݒ肳ꂽsf[^
	 * @param date XV
	 * @param data XVf[^l
	 * @throws RemoteException
	 */
	void updateSeperateSchedule(
			SchedulePointRowDto dto,
			Date date,
			WifeDataSchedule data) throws RemoteException;
}
