package org.F11.scada.security.auth.login;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

import org.F11.scada.WifeUtilities;
import org.F11.scada.security.AccessControlable;
import org.F11.scada.security.WifePrincipal;
import org.F11.scada.security.auth.Crypt;
import org.F11.scada.security.auth.Subject;

/**
 * <p>
 * p[U[ύXƂɎgpAF؃_CAONXłB
 * <p>
 * postgreSQL e[uɒ`ꂽA[U[Ɗ֘AÂꂽ O[v Subject (Ɗ֘AÂꂽvVp)𐶐܂B
 * <p>
 * pX[h͂5񎸔sƔF؏𒆒f܂B
 * 
 * @todo [U[̃bNAs\񐔂̕ύX
 */
public class AuthenticationDialog extends JDialog {
	private static final long serialVersionUID = 3082150358612121359L;
	/** ύXΏۂ Subject */
	private Subject subject;
	/** [U[tB[h */
	private JTextField userField;
	/** pX[htB[h */
	private JPasswordField passField;
	/** ANZXRg[ւ̃[gQ */
	private AccessControlable accessControl;
	/** őF؎s */
	private static final int MAX_AUTHENTICATION_FAIL = 5;
	/** F؎s */
	private int authenticationFail;

	/**
	 * F؃_CAOăCX^X𐶐܂B
	 * 
	 * @param frame et[̎Q
	 */
	public AuthenticationDialog(Frame frame) throws NotBoundException,
			RemoteException, MalformedURLException {
		super(frame, "[U[F؃_CAO", true);
		init();
		pack();
		Dimension dialogDim = getSize();
		dialogDim.width = 230;
		setSize(dialogDim);
		Dimension frameDim = frame.getSize();
		Dimension screenSize = getToolkit().getScreenSize();
		Point location = frame.getLocation();
		location.translate(
				(frameDim.width - dialogDim.width) / 2,
				(frameDim.height - dialogDim.height) / 2);
		location.x = Math.max(0, Math.min(location.x, screenSize.width
				- getSize().width));
		location.y = Math.max(0, Math.min(location.y, screenSize.height
				- getSize().height));
		setLocation(location.x, location.y);
		show();
	}

	/**
	 * 
	 */
	private void init()
			throws NotBoundException,
			RemoteException,
			MalformedURLException {
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		accessControl = (AccessControlable) Naming.lookup(WifeUtilities
				.createRmiActionControl());
		Container cont = getContentPane();

		cont.setLayout(new GridLayout(3, 2));
		JLabel nameLabel = new JLabel("UserName : ");
		JLabel passLabel = new JLabel("Password : ");
		userField = new JTextField();
		passField = new JPasswordField();
		passField.setEchoChar('*');
		JButton ok = new JButton("OK");
		ok.addActionListener(new OkActionListener(this));
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new CancelListener(this));

		cont.add(nameLabel);
		cont.add(userField);
		cont.add(passLabel);
		cont.add(passField);
		cont.add(ok);
		cont.add(cancel);
	}

	/**
	 * F،ʂ Subject CX^XԂ܂BF،ʂɎsꍇ́A null Ԃ܂B
	 * 
	 * @return F،ʂ Subject CX^XԂ܂BF،ʂɎsꍇ́Anull Ԃ܂B
	 */
	public Subject getSubject() {
		return this.subject;
	}

	/**
	 * <p>
	 * OK {^ꂽɎs郊Xi[NXłB
	 * <p>
	 * F؃WbN checkAuthentication \bhɁA[U[ƃpX[h œn܂B
	 */
	static class OkActionListener implements ActionListener {
		AuthenticationDialog dlg;

		OkActionListener(AuthenticationDialog dlg) {
			this.dlg = dlg;
		}

		public void actionPerformed(ActionEvent evt) {
			try {
				dlg.subject = dlg.accessControl.checkAuthentication(
						dlg.userField.getText(),
						Crypt.crypt(dlg.passField.getPassword()));
			} catch (RemoteException ex) {
				JOptionPane.showMessageDialog(
						dlg,
						"F؎Ƀlbg[NG[܂B",
						"F؎Ƀlbg[NG[",
						JOptionPane.ERROR_MESSAGE);
				ex.printStackTrace();
				return;
			} catch (NoSuchAlgorithmException ex2) {
				JOptionPane.showMessageDialog(
						dlg,
						"F؎ɈÍW[݃G[܂B",
						"F؎ɈÍW[݃G[",
						JOptionPane.ERROR_MESSAGE);
				ex2.printStackTrace();
				return;
			}

			if (dlg.subject != null) {
				dlg.dispose();
			} else {
				dlg.authenticationFail++;
				if (dlg.authenticationFail < AuthenticationDialog.MAX_AUTHENTICATION_FAIL) {
					JOptionPane
							.showMessageDialog(
									dlg,
									"[U[pX[h܂Bx͂ĉB\npX[h͑啶E̋ʂ܂B",
									"F؎s",
									JOptionPane.ERROR_MESSAGE);
					try {
						dlg.passField.getDocument().remove(
								0,
								dlg.passField.getPassword().length);
					} catch (BadLocationException ex) {
						ex.printStackTrace();
					}
					dlg.passField.requestFocusInWindow();
				} else {
					dlg.dispose();
				}
			}

			// for (Iterator it = dlg.subject.getPrincipals().iterator();
			// it.hasNext();) {
			// System.out.println(it.next());
			// }
		}
	}

	static class CancelListener implements ActionListener {
		AuthenticationDialog dlg;

		CancelListener(AuthenticationDialog dlg) {
			this.dlg = dlg;
		}

		public void actionPerformed(ActionEvent evt) {
			dlg.dispose();
		}
	}

	public static void main(String[] argv) {
		final JFrame f = new JFrame();
		JButton change = new JButton("؊");
		change.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				try {
					Set pri = new HashSet();
					pri.add(new WifePrincipal("hoge"));
					Subject.createSubject(null, "user1");

					new AuthenticationDialog(f);
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
		});

		f.getContentPane().add(change);
		f.pack();
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
	}
}
