package org.F11.scada.scheduling;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.Logger;

/**
 *  莞ԂXPW[ECe[^[NXł
 */
public class DailyIterator implements ScheduleIterator {
	/** ̓vZJ_[ */
	private final Calendar calendar = Calendar.getInstance();
	/** Logging API */
	private static Logger log = Logger.getLogger(DailyIterator.class);
	/** tH[}b^[ */
	private final DateFormat fmt = DateFormat.getDateTimeInstance();

	/**
	 * EEbw肵āACe[^[܂B
	 *
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 */
	public DailyIterator(int hourOfDay, int minute, int second) {
		this(hourOfDay, minute, second, new Date());
	}

	/**
	 * tEEEbw肵āACe[^[܂B
	 * tIuWFNg̎EEb͈̎EEbŏ㏑܂
	 *
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 * @param date t
	 */
	public DailyIterator(int hourOfDay, int minute, int second, Date date) {
		calendar.setTime(date);
		calendar.set(Calendar.HOUR_OF_DAY, hourOfDay);
		calendar.set(Calendar.MINUTE, minute);
		calendar.set(Calendar.SECOND, second);
		calendar.set(Calendar.MILLISECOND, 0);
		if (!calendar.getTime().before(date)) {
			calendar.add(Calendar.DATE, -1);
		}
	}


	/**
	 * tEEEbw肵āACe[^[܂B
	 * tIuWFNg̎EEb͈̎EEbŏ㏑܂
	 *
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 * @param date t
	 * @param millioffset ~ItZbg
	 */
	public DailyIterator(int hourOfDay, int minute, int second, Date date, int millioffset) {
		calendar.setTime(date);
		calendar.set(Calendar.HOUR_OF_DAY, hourOfDay);
		calendar.set(Calendar.MINUTE, minute);
		calendar.set(Calendar.SECOND, second);
		calendar.add(Calendar.MILLISECOND, millioffset);
		if (!calendar.getTime().before(date)) {
			calendar.add(Calendar.DATE, -1);
		}
	}

	/**
	 * ɎsԂ܂B
	 * @return ɎsԂ܂B
	 */
	public Date next() {
		calendar.add(Calendar.DATE, 1);
		if (log.isInfoEnabled()) {
			log.info("Next schedule date : " + fmt.format(calendar.getTime()));
		}
		return calendar.getTime();
	}
}
