/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/data/WifeDataCalendar.java,v 1.5.2.1 2005/07/06 02:20:44 frdm Exp $
 * $Revision: 1.5.2.1 $
 * $Date: 2005/07/06 02:20:44 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.util.Arrays;

/**
 * J_[̃f[^\܂B
 */
public class WifeDataCalendar implements WifeData, java.io.Serializable {
	/** VAID */
	private static final long serialVersionUID = 3766236079110879046L;
	/** [hf[^\ BigInteger CX^X */
	private final BigInteger[][] bitSet;
	/** ݒ肳Ă郂[h */
	private final int modeCount;
	/** őrbg */
	private static final int MAX_BIT = 31;
	/** ŏrbg */
	private static final int MIN_BIT = 0;
	/** ꌎ̃oCg */
	private static final int MONTH_DATA_BYTE = 4;
	/** PŇ̐ */
	private static final int MONTH_YEAR_COUNT = 12;
	/** ̃CX^X̃nbVR[hł */
	private transient volatile int hashCode;

	/**
	 * RXgN^
	 * private ANZXȂ̂ŁAnew ZqŃCX^X͂ł܂B
	 *  valueOf() \bhgpāACX^XĂB
	 */
	private WifeDataCalendar(BigInteger[][] bitSet, int modeCount) {
		this.bitSet = bitSet;
		this.modeCount = modeCount;
	}

	/**
	 * 0 ŏ WifeDataCalendar CX^X쐬At@Ng\bhłB
	 * @param modeCount ̎ސw肵܂Biʏx + j
	 * @return 0 ŏ WifeDataCalendar CX^X
	 */
	static public WifeDataCalendar valueOf(int modeCount) {
		byte[] b = creataZeroByteArray(MONTH_DATA_BYTE);
		BigInteger[][] bi = new BigInteger[modeCount][MONTH_YEAR_COUNT];
		for (int j = modeCount - 1; j >= 0; j--) {
			for (int i = MONTH_YEAR_COUNT - 1; i >= 0; i--) {
				bi[j][i] = new BigInteger(1, b);
			}
		}
		return new WifeDataCalendar(bi, modeCount);
	}

	/**
	 * oCgf[^𐶐܂B
	 * @param size oCgz̃TCY
	 * @return 0 ŏꂽoCgz
	 */
	private static byte[] creataZeroByteArray(int size) {
		byte[] b = new byte[size];
		Arrays.fill(b, (byte)0x00);
		return b;
	}

	/**
	 * oCgzf[^ɕϊ܂B
	 * @param b oCgz
	 * @return ŏꂽAWordData CX^X(WifeDataɃ_ELXg)
	 */
	public WifeData valueOf(byte[] b) {
		if (b.length != MONTH_DATA_BYTE * MONTH_YEAR_COUNT * modeCount)
			throw new IllegalArgumentException("IllegalArgument length = " + b.length);

		BigInteger[][] bi = new BigInteger[modeCount][MONTH_YEAR_COUNT];
		ByteArrayInputStream is = new ByteArrayInputStream(b);
		byte[] b1 = new byte[MONTH_DATA_BYTE];

		for (int i = 0; i < modeCount; i++) {
			for (int j = 0; j < MONTH_YEAR_COUNT; j++) {
				is.read(b1, 0, MONTH_DATA_BYTE);
				bi[i][j] = new BigInteger(1, b1);
			}
		}

		return new WifeDataCalendar(bi, modeCount);
	}

	/**
	 * ̃f[^̒loCgzϊĕԂ܂B
	 * @return oCgz
	 */
	public byte[] toByteArray() {
		ByteArrayOutputStream os = new ByteArrayOutputStream(MONTH_DATA_BYTE * MONTH_YEAR_COUNT * modeCount);

		for (int i = 0; i < modeCount; i++) {
			for (int j = 0; j < MONTH_YEAR_COUNT; j++) {
				byte[] b = bitSet[i][j].toByteArray();
				if (b.length <= MONTH_DATA_BYTE) {
					byte[] rb = creataZeroByteArray(MONTH_DATA_BYTE);
					System.arraycopy(b, 0, rb, rb.length - b.length, b.length);
					try {
						os.write(rb);
					} catch (java.io.IOException ex) {
						ex.printStackTrace();
					}
				} else {
					byte[] rb = creataZeroByteArray(MONTH_DATA_BYTE);
					System.arraycopy(b, b.length - rb.length, rb, 0, rb.length);
					try {
						os.write(rb);
					} catch (java.io.IOException ex) {
						ex.printStackTrace();
					}
				}
			}
		}
		return os.toByteArray();
	}

	/**
	 * w肵rbgݒ肵 WifeDataCalendar Ԃ܂B
	 * @param mode ݒ胂[h
	 * @param month 
	 * @param bitNumber 
	 * @return rbgݒ肵AWifeDataCalendar CX^XB
	 */
	public WifeDataCalendar setBit(int mode, int month, int bitNumber) {
		if (isNormalArgument(mode, month, bitNumber)) {
			int n = reverse(bitNumber);
			for (int i = 0; i < bitSet.length; i++) {
				if (i == mode) {
					if (bitSet[i][month].testBit(n)) {
						bitSet[i][month] = bitSet[i][month].clearBit(n);
					} else {
						bitSet[i][month] = bitSet[i][month].setBit(n);
					}
				} else {
					bitSet[i][month] = bitSet[i][month].clearBit(n);
				}
			}
			return new WifeDataCalendar(bitSet, modeCount);
		} else {
			throw new java.lang.IllegalArgumentException("IllegalArgument mode:" +
														 mode +
														 " month:" +
														 month +
														 " bitNumber:" +
														 bitNumber
														 );
		}
	}

	/**
	 * w肵rbgNA WifeDataCalendar Ԃ܂B
	 * @return rbgNAAWifeDataCalendar CX^XB
	public WifeDataCalendar clearBit(int mode, int month, int bitNumber) {
		if (isNormalArgument(mode, month, bitNumber)) {
			int n = reverse(bitNumber);
			bitSet[mode][month] = bitSet[mode][month].clearBit(n);
			return new WifeDataCalendar(bitSet, modeCount);
		} else {
			throw new java.lang.IllegalArgumentException("IllegalArgument mode:" +
														 mode +
														 " month:" +
														 month +
														 " bitNumber:" +
														 bitNumber
														 );
		}
	}
	 */

	/**
	 * w肵rbgeXg܂B
	 * @param mode ݒ胂[h
	 * @param month 
	 * @param bitNumber 
	 * @return w肵rbg On Ȃ trueAOff Ȃ false Ԃ܂B
	 */
	public boolean testBit(int mode, int month, int bitNumber) {
		if (isNormalArgument(mode, month, bitNumber)) {
			int n = reverse(bitNumber);
			return bitSet[mode][month].testBit(n);
		} else {
			throw new java.lang.IllegalArgumentException("IllegalArgument mode:" +
														 mode +
														 " month:" +
														 month +
														 " bitNumber:" +
														 bitNumber
														 );
		}
	}

	/**
	 * rbgZ̈ǂ𔻒肵܂B
	 * @param mode ݒ胂[h
	 * @param month 
	 * @param bitNumber 
	 * @return SĂ̈Ȃ trueAȂ false Ԃ܂B
	 */
	private boolean isNormalArgument(int mode, int month, int bitNumber) {
		if (mode < 0 || mode >= modeCount)
			return false;
		if (month < 0 || month >= MONTH_YEAR_COUNT)
			return false;
		if (bitNumber < MIN_BIT || bitNumber > MAX_BIT)
			return false;

		return true;
	}

	/**
	 * rbgʒu𔽓]܂B
	 */
	private int reverse(int n) {
		return n < 16 ? 16 + n : n - 16;
	}

	/**
	 * IuWFNgƎw肳ꂽIuWFNgr܂B
	 * rbg\̔ŕABigInteger NX equals(Object x) ɈˑĂ܂B
	 */
	public boolean equals(Object x) {
		if (x == this) {
			return true;
		}
		if (!(x instanceof WifeDataCalendar)) {
			return false;
		}

		WifeDataCalendar wd = (WifeDataCalendar)x;
		if (wd.modeCount != this.modeCount)
			return false;

		for (int i = 0; i < bitSet.length; i++) {
			if (!Arrays.equals(bitSet[i], wd.bitSet[i]))
				return false;
		}
		return true;
	}

	/**
	 * nbVR[hlԂ܂B
	 * rbg\̃nbVR[hĺABigInteger NX hashCode() ɈˑĂ܂B
	 */
	public int hashCode() {
		if (hashCode == 0) {
			int result = 17;
			result = 37 * result + modeCount;
			for (int i = 0; i < bitSet.length; i++) {
				for (int j = 0; j < bitSet[i].length; j++) {
					result = 37 * result + bitSet[i][j].hashCode();
				}
			}
			hashCode = result;
		}
		return hashCode;
	}

	/**
	 * \Ԃ܂B
	 * rbg̕\́ABigInteger NX toString(16) ɈˑĂ܂B
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("modeCount:" + modeCount);
		buffer.append(",bit:");
		for (int i = 0; i < modeCount; i++) {
			for (int j = 0; j < MONTH_YEAR_COUNT; j++) {
				buffer.append(bitSet[i][j].toString(16).toUpperCase());
			}
			if (i != (modeCount - 1)) {
			    buffer.append(" ");
			}
		}
		return buffer.toString();
	}

	/**
	 * ̃f[^̃[hԂ܂B
	 * @return ̃f[^̃[h
	 */
	public int getWordSize() {
		return (MONTH_DATA_BYTE * MONTH_YEAR_COUNT * modeCount) / 2;
	}
	
	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new  WifeDataCalendar(bitSet, modeCount);
	}

	/**
	 * ̃J_[Ŏgp̐Ԃ܂B
	 * @return ̃J_[Ŏgp̐Ԃ܂B
	 */	
	public int getSpecialDayCount() {
		return modeCount - 1;
	}
}
