/*
 * Projrct F-11 - Web SCADA for Java Copyright (C) 2002 Freedom, Inc. All Rights
 * Reserved. This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
package org.F11.scada.applet.graph.bargraph2;

import java.rmi.RemoteException;

import javax.swing.Icon;
import javax.swing.JComponent;

import org.F11.scada.Service;

public interface BarGraphModel extends Service {
	/**
	 * o[OtR|[lgԂ܂B
	 * @return
	 */
	public JComponent getJComponent();
	/**
	 * \|CgύX܂B
	 * @param series
	 */
	public void changePoint(BarSeries series) throws RemoteException;
	/**
	 * \f[^̎QƈʒuύX܂B
	 */
	public void changePeriod(int offset);
	/**
	 * XP[PPʒ̃o[̖{Ԃ܂B
	 * @return
	 */
	public int getBarCount();
	/**
	 * XP[̐Ԃ܂B
	 * @return
	 */
	public int getBlockCount();
	/**
	 * \f[^̃}gbNXԂ܂B
	 * @return
	 */
	public BarData[][] getDataMatrix();

	/**
	 * g̃CfbNXݒ肵܂B<br>
	 * V[Ỹ|Cg擾鎞̃CfbNXƂĎgp܂B
	 * @param barIndex
	 */
	public void setBarGraphModelIndex(int barIndex);
	/**
	 * toString()̕Ԃlݒ肵܂B
	 * @param text
	 */
	public void setText(String text);
	/**
	 * R|[lg̃obNOEhC[Wݒ肵܂B
	 * @param icon
	 */
	public void setIcon(Icon icon);
	/**
	 * QƂe[uݒ肵܂B
	 * @param handlerNames
	 */
	public void setHandlerNames(String[] handlerNames);
	/**
	 * XP[PPʒ̃o[̖{ݒ肵܂B
	 * @param count
	 */
	public void setBarCount(int count);
	/**
	 * f[^̎QƓ𑀍삷NXݒ肵܂B
	 * @param refDate
	 */
	public void setReferenceDate(ReferenceDate refDate);
	/**
	 * o[`悷R|[lgݒ肵܂B
	 * @param view
	 */
	public void setBarGraph2View(BarGraph2View view);
	/**
	 * cXP[ǗNXǉ܂B
	 * @param symbol
	 */
	public void setVerticallyScaleModel(VerticallyScaleModel vertical);
	/**
	 * R|[lgɒPʕ\peLXgV{ǉ܂B
	 * @param symbol
	 */
	public void addUnitsSymbol(TextUnitsSymbol symbol);
}
