/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Application;
import application.ApplicationContext;
import application.ResourceMap;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(View.class.getName());
    private final Application application;
    private ResourceMap resourceMap = null;
    private JRootPane rootPane = null;
    private JComponent component = null;
    private JMenuBar menuBar = null;
    private List<JToolBar> toolBars = Collections.emptyList();
    private JComponent toolBarsPanel = null;
    private JComponent statusBar = null;

    public View(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("null application");
        }
        this.application = application;
    }

    public final Application getApplication() {
        return this.application;
    }

    public final ApplicationContext getContext() {
        return this.getApplication().getContext();
    }

    public ResourceMap getResourceMap() {
        if (this.resourceMap == null) {
            this.resourceMap = this.getContext().getResourceMap(this.getClass(), View.class);
        }
        return this.resourceMap;
    }

    public JRootPane getRootPane() {
        if (this.rootPane == null) {
            this.rootPane = new JRootPane();
            this.rootPane.setOpaque(true);
        }
        return this.rootPane;
    }

    private void replaceContentPaneChild(JComponent oldChild, JComponent newChild, String constraint) {
        Container contentPane = this.getRootPane().getContentPane();
        if (oldChild != null) {
            contentPane.remove(oldChild);
        }
        if (newChild != null) {
            contentPane.add((Component)newChild, constraint);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        JComponent oldValue = this.component;
        this.component = component;
        this.replaceContentPaneChild(oldValue, this.component, "Center");
        this.firePropertyChange("component", oldValue, this.component);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(JMenuBar menuBar) {
        JMenuBar oldValue = this.getMenuBar();
        this.menuBar = menuBar;
        this.getRootPane().setJMenuBar(menuBar);
        this.firePropertyChange("menuBar", oldValue, menuBar);
    }

    public List<JToolBar> getToolBars() {
        return this.toolBars;
    }

    public void setToolBars(List<JToolBar> toolBars) {
        if (toolBars == null) {
            throw new IllegalArgumentException("null toolbars");
        }
        List<JToolBar> oldValue = this.getToolBars();
        this.toolBars = Collections.unmodifiableList(new ArrayList<JToolBar>(toolBars));
        JComponent oldToolBarsPanel = this.toolBarsPanel;
        JComponent newToolBarsPanel = null;
        if (this.toolBars.size() == 1) {
            newToolBarsPanel = toolBars.get(0);
        } else if (this.toolBars.size() > 1) {
            newToolBarsPanel = new JPanel();
            for (JToolBar toolBar : this.toolBars) {
                newToolBarsPanel.add(toolBar);
            }
        }
        this.replaceContentPaneChild(oldToolBarsPanel, newToolBarsPanel, "North");
        this.firePropertyChange("toolBars", oldValue, this.toolBars);
    }

    public final JToolBar getToolBar() {
        List<JToolBar> toolBars = this.getToolBars();
        return toolBars.size() == 0 ? null : toolBars.get(0);
    }

    public final void setToolBar(JToolBar toolBar) {
        JToolBar oldValue = this.getToolBar();
        List<JToolBar> toolBars = Collections.emptyList();
        if (toolBar != null) {
            toolBars = Collections.singletonList(toolBar);
        }
        this.setToolBars(toolBars);
        this.firePropertyChange("toolBar", oldValue, toolBar);
    }

    public JComponent getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(JComponent statusBar) {
        JComponent oldValue = this.statusBar;
        this.statusBar = statusBar;
        this.replaceContentPaneChild(oldValue, this.statusBar, "South");
        this.firePropertyChange("statusBar", oldValue, this.statusBar);
    }
}

