/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Application;
import application.ApplicationContext;
import application.ResourceMap;
import application.TaskEvent;
import application.TaskListener;
import application.TaskService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task<T, V>
extends SwingWorker<T, V> {
    private static final Logger logger = Logger.getLogger(Task.class.getName());
    private final Application application;
    private String resourcePrefix;
    private ResourceMap resourceMap;
    private List<TaskListener<T, V>> taskListeners;
    private InputBlocker inputBlocker;
    private String title = null;
    private String description = null;
    private long messageTime = -1L;
    private String message = null;
    private long startTime = -1L;
    private long doneTime = -1L;
    private boolean userCanCancel = true;
    private boolean progressPropertyIsValid = false;
    private TaskService taskService = null;

    private void initTask(ResourceMap resourceMap, String prefix) {
        this.resourceMap = resourceMap;
        this.resourcePrefix = prefix == null || prefix.length() == 0 ? "" : (prefix.endsWith(".") ? prefix : prefix + ".");
        if (resourceMap != null) {
            this.title = resourceMap.getString(this.resourceName("title"), new Object[0]);
            this.description = resourceMap.getString(this.resourceName("description"), new Object[0]);
            this.message = resourceMap.getString(this.resourceName("message"), new Object[0]);
            if (this.message != null) {
                this.messageTime = System.currentTimeMillis();
            }
        }
        this.addPropertyChangeListener(new StatePCL());
        this.taskListeners = new CopyOnWriteArrayList<TaskListener<T, V>>();
    }

    private ResourceMap defaultResourceMap(Application application) {
        return application.getContext().getResourceMap(((Object)((Object)this)).getClass(), Task.class);
    }

    public Task(Application application, ResourceMap resourceMap, String resourcePrefix) {
        this.application = application;
        this.initTask(resourceMap, resourcePrefix);
    }

    public Task(Application application, String resourcePrefix) {
        this.application = application;
        this.initTask(this.defaultResourceMap(application), resourcePrefix);
    }

    public Task(Application application) {
        this.application = application;
        this.initTask(this.defaultResourceMap(application), "");
    }

    public final Application getApplication() {
        return this.application;
    }

    public final ApplicationContext getContext() {
        return this.getApplication().getContext();
    }

    public synchronized TaskService getTaskService() {
        return this.taskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setTaskService(TaskService taskService) {
        TaskService newTaskService;
        TaskService oldTaskService;
        Task task = this;
        synchronized (task) {
            oldTaskService = this.taskService;
            newTaskService = this.taskService = taskService;
        }
        this.firePropertyChange("taskService", oldTaskService, newTaskService);
    }

    protected final String resourceName(String suffix) {
        return this.resourcePrefix + suffix;
    }

    protected final ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public synchronized String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTitle(String title) {
        String newTitle;
        String oldTitle;
        Task task = this;
        synchronized (task) {
            oldTitle = this.title;
            newTitle = this.title = title;
        }
        this.firePropertyChange("title", oldTitle, newTitle);
    }

    public synchronized String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDescription(String description) {
        String newDescription;
        String oldDescription;
        Task task = this;
        synchronized (task) {
            oldDescription = this.description;
            newDescription = this.description = description;
        }
        this.firePropertyChange("description", oldDescription, newDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionDuration(TimeUnit unit) {
        long doneTime;
        long startTime;
        Task task = this;
        synchronized (task) {
            startTime = this.startTime;
            doneTime = this.doneTime;
        }
        long dt = startTime == -1L ? 0L : (doneTime == -1L ? System.currentTimeMillis() - startTime : doneTime - startTime);
        return unit.convert(Math.max(0L, dt), TimeUnit.MILLISECONDS);
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(String message) {
        String newMessage;
        String oldMessage;
        Task task = this;
        synchronized (task) {
            oldMessage = this.message;
            newMessage = this.message = message;
            this.messageTime = System.currentTimeMillis();
        }
        this.firePropertyChange("message", oldMessage, newMessage);
    }

    protected final void message(String formatResourceKey, Object ... args) {
        ResourceMap resourceMap = this.getResourceMap();
        if (resourceMap != null) {
            this.setMessage(resourceMap.getString(this.resourceName(formatResourceKey), args));
        } else {
            this.setMessage(formatResourceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageDuration(TimeUnit unit) {
        long messageTime;
        Task task = this;
        synchronized (task) {
            messageTime = this.messageTime;
        }
        long dt = messageTime == -1L ? 0L : Math.max(0L, System.currentTimeMillis() - messageTime);
        return unit.convert(dt, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean getUserCanCancel() {
        return this.userCanCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserCanCancel(boolean userCanCancel) {
        boolean newValue;
        boolean oldValue;
        Task task = this;
        synchronized (task) {
            oldValue = this.userCanCancel;
            newValue = this.userCanCancel = userCanCancel;
        }
        this.firePropertyChange("userCanCancel", oldValue, newValue);
    }

    public synchronized boolean isProgressPropertyValid() {
        return this.progressPropertyIsValid;
    }

    protected final void setProgress(int value, int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (value < min || value > max) {
            throw new IllegalArgumentException("invalid value");
        }
        float percentage = (float)(value - min) / (float)(max - min);
        this.setProgress(Math.round(percentage * 100.0f));
    }

    protected final void setProgress(float percentage) {
        if ((double)percentage < 0.0 || (double)percentage > 1.0) {
            throw new IllegalArgumentException("invalid percentage");
        }
        this.setProgress(Math.round(percentage * 100.0f));
    }

    protected final void setProgress(float value, float min, float max) {
        if (min >= max) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (value < min || value > max) {
            throw new IllegalArgumentException("invalid value");
        }
        float percentage = (value - min) / (max - min);
        this.setProgress(Math.round(percentage * 100.0f));
    }

    public final boolean isPending() {
        return this.getState() == SwingWorker.StateValue.PENDING;
    }

    public final boolean isStarted() {
        return this.getState() == SwingWorker.StateValue.STARTED;
    }

    protected void process(List<V> values) {
        this.fireProcessListeners(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void done() {
        try {
            if (this.isCancelled()) {
                this.cancelled();
            } else {
                try {
                    this.succeeded(this.get());
                }
                catch (InterruptedException e) {
                    this.interrupted(e);
                }
                catch (ExecutionException e) {
                    this.failed(e.getCause());
                }
            }
        }
        finally {
            try {
                this.finished();
            }
            finally {
                this.setTaskService(null);
            }
        }
    }

    protected void cancelled() {
    }

    protected void succeeded(T result) {
    }

    protected void interrupted(InterruptedException e) {
    }

    protected void failed(Throwable cause) {
        String msg = String.format("%s failed: %s", new Object[]{this, cause});
        logger.log(Level.SEVERE, msg, cause);
    }

    protected void finished() {
    }

    public void addTaskListener(TaskListener<T, V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.taskListeners.add(listener);
    }

    public void removeTaskListener(TaskListener<T, V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.taskListeners.remove(listener);
    }

    public TaskListener<T, V>[] getTaskListeners() {
        return this.taskListeners.toArray(new TaskListener[this.taskListeners.size()]);
    }

    private void fireProcessListeners(List<V> values) {
        TaskEvent<List<V>> event = new TaskEvent<List<V>>(this, values);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.process(event);
        }
    }

    private void fireDoInBackgroundListeners() {
        TaskEvent<Object> event = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.doInBackground(event);
        }
    }

    private void fireSucceededListeners(T result) {
        TaskEvent<T> event = new TaskEvent<T>(this, result);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.succeeded(event);
        }
    }

    private void fireCancelledListeners() {
        TaskEvent<Object> event = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.cancelled(event);
        }
    }

    private void fireInterruptedListeners(InterruptedException e) {
        TaskEvent<InterruptedException> event = new TaskEvent<InterruptedException>(this, e);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.interrupted(event);
        }
    }

    private void fireFailedListeners(Throwable e) {
        TaskEvent<Throwable> event = new TaskEvent<Throwable>(this, e);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.failed(event);
        }
    }

    private void fireFinishedListeners() {
        TaskEvent<Object> event = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> listener : this.taskListeners) {
            listener.finished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCompletionListeners() {
        try {
            if (this.isCancelled()) {
                this.fireCancelledListeners();
            } else {
                try {
                    this.fireSucceededListeners(this.get());
                }
                catch (InterruptedException e) {
                    this.fireInterruptedListeners(e);
                }
                catch (ExecutionException e) {
                    this.fireFailedListeners(e.getCause());
                }
            }
        }
        finally {
            this.fireFinishedListeners();
        }
    }

    public final InputBlocker getInputBlocker() {
        return this.inputBlocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInputBlocker(InputBlocker inputBlocker) {
        InputBlocker newInputBlocker;
        InputBlocker oldInputBlocker;
        if (this.getTaskService() != null) {
            throw new IllegalStateException("task already being executed");
        }
        Task task = this;
        synchronized (task) {
            oldInputBlocker = this.inputBlocker;
            newInputBlocker = this.inputBlocker = inputBlocker;
        }
        this.firePropertyChange("inputBlocker", oldInputBlocker, newInputBlocker);
    }

    public static abstract class InputBlocker
    extends AbstractBean {
        private final Task task;
        private final BlockingScope scope;
        private final Object target;

        public InputBlocker(Task task, BlockingScope scope, Object target) {
            if (task == null) {
                throw new IllegalArgumentException("null task");
            }
            if (task.getTaskService() != null) {
                throw new IllegalStateException("task already being executed");
            }
            this.task = task;
            this.scope = scope;
            this.target = target;
        }

        public final Task getTask() {
            return this.task;
        }

        public final BlockingScope getScope() {
            return this.scope;
        }

        public final Object getTarget() {
            return this.target;
        }

        protected abstract void block();

        protected abstract void unblock();
    }

    private class StatePCL
    implements PropertyChangeListener {
        private StatePCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("state".equals(propertyName)) {
                SwingWorker.StateValue state = (SwingWorker.StateValue)e.getNewValue();
                Task task = (Task)((Object)e.getSource());
                switch (state) {
                    case STARTED: {
                        this.taskStarted(task);
                        break;
                    }
                    case DONE: {
                        this.taskDone(task);
                    }
                }
            } else if ("progress".equals(propertyName)) {
                Task task = Task.this;
                synchronized (task) {
                    Task.this.progressPropertyIsValid = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskStarted(Task task) {
            Task task2 = Task.this;
            synchronized (task2) {
                Task.this.startTime = System.currentTimeMillis();
            }
            Task.this.firePropertyChange("started", false, true);
            Task.this.fireDoInBackgroundListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskDone(Task task) {
            Task task2 = Task.this;
            synchronized (task2) {
                Task.this.doneTime = System.currentTimeMillis();
            }
            try {
                task.removePropertyChangeListener(this);
                Task.this.firePropertyChange("done", false, true);
                Task.this.fireCompletionListeners();
            }
            finally {
                Task.this.firePropertyChange("completed", false, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockingScope {
        NONE,
        ACTION,
        COMPONENT,
        WINDOW,
        APPLICATION;

    }
}

