/*
 * Decompiled with CFR 0.152.
 */
package program;

import java.text.DecimalFormat;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.emulator.PlcControl;
import program.PlcRunnable;

public class MoveAnalog
implements PlcRunnable {
    private int second = 0;
    private int mokuhyo;
    private int preValue;
    private int curValue;
    private int nokori;
    private int average;
    private int yosou;
    private int count;
    private int keisuu = 20;

    public void startUpCall(PlcControl plc) throws Exception {
    }

    public void cycleCall(PlcControl plc) throws Exception {
        this.actionPerformed(plc);
    }

    public void actionPerformed(PlcControl plc) {
        if (null != plc) {
            for (int i = 500; i < 513; ++i) {
                plc.writePlcMem("DM", i, this.randomNumber());
            }
            plc.writePlcMem("DM", 3313, this.intToByte(this.second));
            plc.writePlcMem("DM", 3314, this.intToByte((1799 - this.second) / 60));
            plc.writePlcMem("DM", 3315, this.intToByte((1799 - this.second) % 60));
            if (this.second % 10 == 0) {
                this.curValue = (int)((double)this.curValue + Math.random() * (double)this.keisuu);
                plc.writePlcMem("DM", 3307, this.intToByte(this.curValue));
            }
            if (this.second % 30 == 0) {
                this.calcDemand(plc);
            }
            ++this.second;
            if (1800 <= this.second) {
                this.second = 0;
            }
        }
    }

    private byte[] randomNumber() {
        long value = Math.abs(Math.round(Math.random() * 10000.0));
        if (value > 4000L) {
            value = 4000L - value % 4000L;
        }
        if (value < 0L) {
            value = Math.abs(value);
        }
        StringBuffer sb = new StringBuffer(Integer.toString((int)value));
        while (sb.length() < 4) {
            sb.insert(0, '0');
        }
        return Util.toByteArrey(sb.toString());
    }

    private void calcDemand(PlcControl plc) {
        this.mokuhyo = this.byteToInt(plc.readPlcMem("DM", 3301, 1));
        if (this.count == 0) {
            this.curValue = 0;
            this.preValue = 0;
            this.keisuu = this.keisuu == 20 ? 18 : 20;
        }
        this.nokori = this.mokuhyo - this.curValue;
        if (this.nokori < 0) {
            this.nokori = 0;
        }
        this.average = (this.curValue - this.preValue) * 60;
        if (this.average < 0) {
            this.average = 0;
        }
        this.yosou = (this.curValue - this.preValue) * (60 - this.count) + this.curValue;
        if (this.yosou < 0) {
            this.yosou = 0;
        }
        plc.writePlcMem("DM", 3306, this.intToByte(this.preValue));
        plc.writePlcMem("DM", 3307, this.intToByte(this.curValue));
        plc.writePlcMem("DM", 3308, this.intToByte(this.nokori));
        plc.writePlcMem("DM", 3309, this.intToByte(this.average));
        plc.writePlcMem("DM", 3310, this.intToByte(this.yosou));
        plc.writePlcMem("DM", 3316, this.intToByte(this.count));
        plc.writePlcMem("DM", 19063, this.intToByte(this.count));
        this.preValue = this.curValue;
        ++this.count;
        if (60 <= this.count) {
            this.count = 0;
        }
    }

    private byte[] intToByte(int value) {
        DecimalFormat f = new DecimalFormat("0000");
        return Util.toByteArrey(String.valueOf(f.format(value)));
    }

    private int byteToInt(byte[] value) {
        return Integer.parseInt(Util.toString(value));
    }
}

