/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.receiver;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import jp.co.frdm.Vamp.receiver.AbstractReceiver;

public class UDPReceiver
extends AbstractReceiver {
    private DatagramSocket socket;
    private byte[] recvBuff = new byte[4096];
    private InetAddress hostIpAddr;
    private int hostPortNo;

    public UDPReceiver(int portNo, long delay) {
        super(portNo, delay);
    }

    protected boolean open() {
        try {
            this.socket = new DatagramSocket(this.portNo);
            this.socket.setSoTimeout(200);
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void close() {
        this.socket.close();
    }

    protected byte[] recv() {
        DatagramPacket packet = new DatagramPacket(this.recvBuff, this.recvBuff.length);
        try {
            this.socket.receive(packet);
        }
        catch (IOException e) {
            return null;
        }
        this.hostIpAddr = packet.getAddress();
        this.hostPortNo = packet.getPort();
        byte[] recvData = new byte[packet.getLength()];
        System.arraycopy(this.recvBuff, 0, recvData, 0, packet.getLength());
        return recvData;
    }

    protected void send(byte[] sendData) throws Exception {
        DatagramPacket packet = new DatagramPacket(sendData, sendData.length, this.hostIpAddr, this.hostPortNo);
        this.socket.send(packet);
    }
}

