/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.receiver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.frdm.Vamp.receiver.AbstractReceiver;
import jp.co.frdm.Vamp.receiver.UDPReceiver;

public class ReceiverFactory {
    private static ReceiverFactory instance = new ReceiverFactory();
    private Map receivers = new HashMap();
    private long delayTimer = 30L;

    private ReceiverFactory() {
    }

    public static AbstractReceiver getReceiver(int portNo) {
        AbstractReceiver receiver = (AbstractReceiver)ReceiverFactory.instance.receivers.get(String.valueOf(portNo));
        if (receiver == null) {
            receiver = new UDPReceiver(portNo, ReceiverFactory.instance.delayTimer);
            receiver.start();
            ReceiverFactory.instance.receivers.put(String.valueOf(portNo), receiver);
        }
        return receiver;
    }

    public static void allClear() {
        for (AbstractReceiver receiver : ReceiverFactory.instance.receivers.values()) {
            receiver.stop();
        }
        ReceiverFactory.instance.receivers.clear();
    }

    public static int getReceiverCount() {
        return ReceiverFactory.instance.receivers.size();
    }

    public static long addDelay(long l) {
        ReceiverFactory.instance.delayTimer += l;
        Iterator it = ReceiverFactory.instance.receivers.keySet().iterator();
        while (it.hasNext()) {
            AbstractReceiver receiver = (AbstractReceiver)ReceiverFactory.instance.receivers.get(String.valueOf(it.next()));
            receiver.setDelay(ReceiverFactory.instance.delayTimer);
        }
        return ReceiverFactory.instance.delayTimer;
    }
}

