/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.emulator.AbstractPlc;
import jp.co.frdm.Vamp.emulator.PlcMemory;
import jp.co.frdm.Vamp.emulator.converter.FINS;

public class CS1
extends AbstractPlc {
    private int emBancks;
    private Map memoryMap;
    private Map memKindMap;
    private FINS converter;

    public byte[] recvPerformed(byte[] recvData) {
        if (!this.getStat()) {
            return null;
        }
        if (!this.converter.checkCommand(recvData)) {
            return null;
        }
        this.incCount();
        switch (this.converter.getCommandKind()) {
            case 257: {
                return this.commandRead();
            }
            case 258: {
                return this.commandWrite();
            }
            case 1537: {
                return this.converter.getResponse(((PlcMemory)this.memoryMap.get("STAT")).getData(0, 13));
            }
            case 1793: {
                return this.converter.getTimeResponse(this.getPlcTime());
            }
            case 1794: {
                return this.converter.setTimeResponse(this.getPlcTime());
            }
        }
        return this.converter.getErrorResponse(1025);
    }

    public void setPlcParam(StringTokenizer st) {
        int i;
        this.converter = new FINS(Integer.parseInt(st.nextToken("\t")), Integer.parseInt(st.nextToken("\t")), 0);
        this.emBancks = Integer.parseInt(st.nextToken("\t"));
        this.memoryMap = new HashMap();
        this.memoryMap.put("STAT", new PlcMemory.PlcWordMemory(13));
        this.memoryMap.put("CIO", new PlcMemory.PlcWordMemory(6144));
        this.memoryMap.put("WR", new PlcMemory.PlcWordMemory(512));
        this.memoryMap.put("HR", new PlcMemory.PlcWordMemory(512));
        this.memoryMap.put("AR", new PlcMemory.PlcWordMemory(960));
        this.memoryMap.put("DM", new PlcMemory.PlcWordMemory(32768));
        for (i = 0; i < this.emBancks && i < 13; ++i) {
            this.memoryMap.put("EM" + Integer.toHexString(i), new PlcMemory.PlcWordMemory(32768));
        }
        this.memKindMap = new HashMap();
        this.memKindMap.put(new Integer(128), this.memoryMap.get("CIO"));
        this.memKindMap.put(new Integer(176), this.memoryMap.get("CIO"));
        this.memKindMap.put(new Integer(177), this.memoryMap.get("WR"));
        this.memKindMap.put(new Integer(178), this.memoryMap.get("HR"));
        this.memKindMap.put(new Integer(179), this.memoryMap.get("AR"));
        this.memKindMap.put(new Integer(130), this.memoryMap.get("DM"));
        for (i = 0; i < this.emBancks && i < 8; ++i) {
            this.memKindMap.put(new Integer(144 + i), this.memoryMap.get("EM" + Integer.toHexString(i)));
        }
        for (i = 0; i < this.emBancks && i < 13; ++i) {
            this.memKindMap.put(new Integer(160 + i), this.memoryMap.get("EM" + Integer.toHexString(i)));
        }
    }

    public String getPlcParam() {
        return this.getName() + "\t" + String.valueOf(this.getPortNo()) + "\tCS1\t" + this.converter.getParam() + "\t" + String.valueOf(this.emBancks);
    }

    public String getPlcInfo() {
        return "CS1 " + this.converter.getInfo() + " EM " + String.valueOf(this.emBancks);
    }

    public List getPlcMemNames() {
        ArrayList list = new ArrayList(this.memoryMap.keySet());
        Collections.sort(list);
        return list;
    }

    public void writePlcMem(String memName, int addr, byte[] data) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            mem.setData(addr, data);
        }
    }

    public byte[] readPlcMem(String memName, int addr, int wordLen) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            return mem.getData(addr, wordLen);
        }
        return null;
    }

    public int getPlcMemMax(String memName) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            return mem.getAddressMax();
        }
        return 0;
    }

    private byte[] commandRead() {
        PlcMemory mem;
        Integer kind = new Integer(this.converter.getMemoryKind());
        int addr = this.converter.getMemoryAdder();
        int wlen = this.converter.getWordLength();
        if (128 == kind) {
            if (2555 < addr && addr < 2816) {
                return this.converter.getErrorResponse(4356);
            }
            if (2816 <= addr) {
                kind = new Integer(179);
                addr -= 2816;
            }
        }
        if ((mem = (PlcMemory)this.memKindMap.get(kind)) != null) {
            byte[] data = mem.getData(addr, wlen);
            if (data != null) {
                return this.converter.getResponse(data);
            }
            return this.converter.getErrorResponse(4356);
        }
        return this.converter.getErrorResponse(4353);
    }

    private byte[] commandWrite() {
        PlcMemory mem;
        Integer kind = new Integer(this.converter.getMemoryKind());
        int addr = this.converter.getMemoryAdder();
        if (128 == kind) {
            if (2555 < addr && addr < 2816) {
                return this.converter.getErrorResponse(4356);
            }
            if (2816 <= addr) {
                kind = new Integer(179);
                addr -= 2816;
            }
        }
        if ((mem = (PlcMemory)this.memKindMap.get(kind)) != null) {
            try {
                mem.setData(addr, this.converter.getData());
                return this.converter.getErrorResponse(0);
            }
            catch (IndexOutOfBoundsException ex) {
                return this.converter.getErrorResponse(4356);
            }
        }
        return this.converter.getErrorResponse(4353);
    }

    public String getRecvMessage() {
        return Util.toString(this.converter.getRecvData());
    }

    public String getSendMessage() {
        return Util.toString(this.converter.getSendData());
    }
}

