/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.co.frdm.Vamp.VampBundle;
import jp.co.frdm.Vamp.emulator.PlcControl;

public class EditControlPanel
extends JPanel {
    private PlcControl plc;
    private Frame parent;
    ButtonGroup btnGroup3 = new ButtonGroup();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JLabel plcName = new JLabel();
    JRadioButton rbStop = new JRadioButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JRadioButton rbStart = new JRadioButton();
    GridLayout gridLayout2 = new GridLayout();
    JLabel jLabel8 = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JLabel plcTime = new JLabel();
    JButton incButton = new JButton();
    JButton decButton = new JButton();
    JTextField jTextField1 = new JTextField();
    JButton jButton1 = new JButton();
    JPanel jPanel7 = new JPanel(new GridLayout(0, 1));
    JLabel recvMsg = new JLabel("");
    JLabel sendMsg = new JLabel("");

    public EditControlPanel(Frame parent, PlcControl plc) {
        this.parent = parent;
        try {
            this.jbInit();
            this.plc = plc;
            this.jTextField1.setText(plc.getRunProgram());
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jPanel5.setLayout(this.flowLayout1);
        this.plcName.setText(VampBundle.getString("plc_run"));
        this.rbStop.setText(VampBundle.getString("off"));
        this.flowLayout1.setHgap(20);
        this.rbStart.setToolTipText("");
        this.rbStart.setText(VampBundle.getString("on"));
        this.gridLayout2.setRows(3);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setVgap(1);
        this.jLabel8.setText(VampBundle.getString("communication"));
        this.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(4);
        this.plcTime.setText(VampBundle.getString("plctime"));
        this.incButton.setPreferredSize(new Dimension(21, 23));
        this.incButton.setMargin(new Insets(0, 0, 0, 0));
        this.incButton.setText(">");
        this.incButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditControlPanel.this.incButton_actionPerformed(e);
            }
        });
        this.decButton.setPreferredSize(new Dimension(21, 23));
        this.decButton.setMargin(new Insets(0, 0, 0, 0));
        this.decButton.setText("<");
        this.decButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditControlPanel.this.decButton_actionPerformed(e);
            }
        });
        this.jTextField1.setMinimumSize(new Dimension(70, 21));
        this.jTextField1.setPreferredSize(new Dimension(70, 21));
        this.jTextField1.setText("jTextField1");
        this.jButton1.setMinimumSize(new Dimension(79, 23));
        this.jButton1.setPreferredSize(new Dimension(79, 23));
        this.jButton1.setText(VampBundle.getString("commit"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditControlPanel.this.jButton1_actionPerformed(e);
            }
        });
        this.jPanel5.add((Component)this.plcName, null);
        this.jPanel5.add((Component)this.jTextField1, null);
        this.jPanel5.add((Component)this.jButton1, null);
        this.jPanel4.add((Component)this.jLabel8, null);
        this.jPanel4.add((Component)this.rbStart, null);
        this.jPanel4.add((Component)this.rbStop, null);
        this.jPanel6.add((Component)this.plcTime, null);
        this.jPanel6.add((Component)this.decButton, null);
        this.jPanel6.add((Component)this.incButton, null);
        this.jPanel7.add((Component)this.recvMsg, null);
        this.recvMsg.setBackground(Color.green);
        this.recvMsg.setOpaque(true);
        this.jPanel7.add((Component)this.sendMsg, null);
        this.sendMsg.setBackground(Color.yellow);
        this.sendMsg.setOpaque(true);
        this.btnGroup3.add(this.rbStart);
        this.btnGroup3.add(this.rbStop);
        this.add((Component)this.jPanel4, null);
        this.add((Component)this.jPanel6, null);
        this.add((Component)this.jPanel5, null);
        this.add((Component)this.jPanel7, null);
        this.rbStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditControlPanel.this.rbStart_actionPerformed(e);
            }
        });
        this.rbStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditControlPanel.this.rbStop_actionPerformed(e);
            }
        });
    }

    private void rbStart_actionPerformed(ActionEvent e) {
        this.plc.setStat(true);
        this.parent.repaint();
        this.refresh();
    }

    private void rbStop_actionPerformed(ActionEvent e) {
        this.plc.setStat(false);
        this.parent.repaint();
        this.refresh();
    }

    void incButton_actionPerformed(ActionEvent e) {
        Calendar cal = this.plc.getPlcTime();
        cal.add(13, 1);
        this.refresh();
    }

    void decButton_actionPerformed(ActionEvent e) {
        Calendar cal = this.plc.getPlcTime();
        cal.add(13, -1);
        this.refresh();
    }

    public void refresh() {
        this.plcTime.setText(this.plc.getPlcTime().getTime().toString());
        if (this.plc.getStat()) {
            this.rbStart.setSelected(true);
        } else {
            this.rbStop.setSelected(true);
        }
        String msg = this.plc.getRecvMessage();
        if (null != msg) {
            this.recvMsg.setText(msg.substring(0, Math.min(30, msg.length())));
        }
        if (null != (msg = this.plc.getSendMessage())) {
            this.sendMsg.setText(msg.substring(0, Math.min(30, msg.length())));
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        try {
            this.plc.setRunProgram(this.jTextField1.getText());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            JOptionPane.showConfirmDialog(null, VampBundle.getString("plc_run_err"), VampBundle.getString("err"), -1);
        }
    }
}

