/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jp.co.frdm.Vamp.VampBundle;
import jp.co.frdm.Vamp.emulator.AbstractPlc;
import jp.co.frdm.Vamp.emulator.PlcClock;

public class PlcTable
extends AbstractTableModel
implements ActionListener {
    private static final long serialVersionUID = -7209067215071126157L;
    private transient PlcClock timer;
    private static final String[] STAT = new String[2];
    private static final String[] COLUMN_NAME;
    private static final int[] COLUMN_WIDTH;
    private static final String ETC_MSG = "???";
    private List plcList = new ArrayList();

    public PlcTable() {
        this.timer = PlcClock.getInstance();
        this.timer.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.plcList.size(); ++i) {
            this.fireTableCellUpdated(i, 3);
        }
    }

    public void addPlc(AbstractPlc plc) {
        this.plcList.add(plc);
        this.fireTableStructureChanged();
    }

    public AbstractPlc getPlc(int index) {
        if (index < 0 || this.plcList.size() <= index) {
            return null;
        }
        return (AbstractPlc)this.plcList.get(index);
    }

    public void removePlc(AbstractPlc plc) {
        plc.stopPlc();
        this.plcList.remove(plc);
        this.fireTableStructureChanged();
    }

    public void removeAllPlc() {
        for (int i = 0; i < this.plcList.size(); ++i) {
            ((AbstractPlc)this.plcList.get(i)).stopPlc();
        }
        this.plcList.clear();
        this.fireTableStructureChanged();
    }

    public static int getColomnWidth(int index) {
        return COLUMN_WIDTH[index];
    }

    public int getRowCount() {
        return this.plcList.size();
    }

    public int getColumnCount() {
        return COLUMN_NAME.length;
    }

    public Object getValueAt(int row, int column) {
        AbstractPlc plc = (AbstractPlc)this.plcList.get(row);
        switch (column) {
            case 0: {
                return plc.getStat() ? STAT[0] : STAT[1];
            }
            case 1: {
                return plc.getName();
            }
            case 2: {
                return String.valueOf(plc.getPortNo());
            }
            case 3: {
                return String.valueOf(plc.getCommCount());
            }
            case 4: {
                return plc.getPlcInfo();
            }
        }
        return ETC_MSG;
    }

    public String getColumnName(int column) {
        return COLUMN_NAME[column];
    }

    static {
        PlcTable.STAT[0] = VampBundle.getString("connect");
        PlcTable.STAT[1] = VampBundle.getString("disconnected");
        COLUMN_NAME = new String[5];
        PlcTable.COLUMN_NAME[0] = VampBundle.getString("status");
        PlcTable.COLUMN_NAME[1] = VampBundle.getString("name");
        PlcTable.COLUMN_NAME[2] = VampBundle.getString("port");
        PlcTable.COLUMN_NAME[3] = VampBundle.getString("sent");
        PlcTable.COLUMN_NAME[4] = VampBundle.getString("attributes");
        COLUMN_WIDTH = new int[]{30, 60, 30, 30, 60};
    }
}

