/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Stack;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IBatchStatement;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractOperation;

public class DeleteAllOperation
extends AbstractOperation {
    DeleteAllOperation() {
    }

    protected String getDeleteAllCommand() {
        return "delete from ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        IDataSet databaseDataSet = connection.createDataSet();
        DatabaseConfig databaseConfig = connection.getConfig();
        IStatementFactory statementFactory = (IStatementFactory)databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
        IBatchStatement statement = statementFactory.createBatchStatement(connection);
        try {
            String tableName;
            int count = 0;
            Stack<String> tableNames = new Stack<String>();
            HashSet<String> tablesSeen = new HashSet<String>();
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                tableName = iterator.getTableMetaData().getTableName();
                if (tablesSeen.contains(tableName)) continue;
                tableNames.push(tableName);
                tablesSeen.add(tableName);
            }
            while (!tableNames.isEmpty()) {
                tableName = (String)tableNames.pop();
                ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
                tableName = databaseMetaData.getTableName();
                StringBuffer sqlBuffer = new StringBuffer(128);
                sqlBuffer.append(this.getDeleteAllCommand());
                sqlBuffer.append(this.getQualifiedName(connection.getSchema(), tableName, connection));
                statement.addBatch(sqlBuffer.toString());
                ++count;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        finally {
            statement.close();
        }
    }
}

