/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BlobDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class OracleBlobDataType
extends BlobDataType {
    private static final Integer DURATION_SESSION = new Integer(1);
    private static final Integer MODE_READWRITE = new Integer(1);
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return this.typeCast(resultSet.getBlob(column));
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.getBlob(value, statement.getConnection()));
    }

    private Object getBlob(Object value, Connection connection) throws TypeCastException {
        Object tempBlob = null;
        try {
            Class<?> aBlobClass = Class.forName("oracle.sql.BLOB");
            Method createTemporaryMethod = aBlobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = OracleBlobDataType.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            tempBlob = createTemporaryMethod.invoke(null, connection, Boolean.TRUE, DURATION_SESSION);
            Method openMethod = aBlobClass.getMethod("open", Integer.TYPE);
            openMethod.invoke(tempBlob, MODE_READWRITE);
            Method getOutputStreamMethod = tempBlob.getClass().getMethod("getBinaryOutputStream", new Class[0]);
            OutputStream tempBlobOutputStream = (OutputStream)getOutputStreamMethod.invoke(tempBlob, new Object[0]);
            tempBlobOutputStream.write((byte[])this.typeCast(value));
            tempBlobOutputStream.flush();
            tempBlobOutputStream.close();
            Method closeMethod = tempBlob.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(tempBlob, new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        catch (IOException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        catch (ClassNotFoundException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        return tempBlob;
    }

    private void freeTemporaryBlob(Object tempBlob) throws TypeCastException {
        if (tempBlob == null) {
            return;
        }
        try {
            Method freeTemporaryMethod = tempBlob.getClass().getMethod("freeTemporary", new Class[0]);
            freeTemporaryMethod.invoke(tempBlob, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException("Error freeing Oracle BLOB", e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException("Error freeing Oracle BLOB", e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException("Error freeing Oracle BLOB", e.getTargetException());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

