/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.PagerUtil;

public class PagerViewHelper
implements PagerCondition {
    private static final int DEFAULT_DISPLAY_PAGE_MAX = 9;
    private final PagerCondition condition;
    private final int displayPageMax;

    public PagerViewHelper(PagerCondition condition) {
        this(condition, 9);
    }

    public PagerViewHelper(PagerCondition condition, int displayPageMax) {
        this.condition = condition;
        this.displayPageMax = displayPageMax;
    }

    public int getCount() {
        return this.condition.getCount();
    }

    public void setCount(int count) {
        this.condition.setCount(count);
    }

    public int getLimit() {
        return this.condition.getLimit();
    }

    public void setLimit(int limit) {
        this.condition.setLimit(limit);
    }

    public int getOffset() {
        return this.condition.getOffset();
    }

    public void setOffset(int offset) {
        this.condition.setOffset(offset);
    }

    public boolean isPrev() {
        return PagerUtil.isPrev(this.condition);
    }

    public boolean isNext() {
        return PagerUtil.isNext(this.condition);
    }

    public int getCurrentLastOffset() {
        return PagerUtil.getCurrentLastOffset(this.condition);
    }

    public int getNextOffset() {
        return PagerUtil.getNextOffset(this.condition);
    }

    public int getPrevOffset() {
        return PagerUtil.getPrevOffset(this.condition);
    }

    public int getPageIndex() {
        return PagerUtil.getPageIndex(this.condition);
    }

    public int getPageCount() {
        return PagerUtil.getPageCount(this.condition);
    }

    public int getLastPageIndex() {
        return PagerUtil.getLastPageIndex(this.condition);
    }

    public int getDisplayPageIndexBegin() {
        return PagerUtil.getDisplayPageIndexBegin(this.condition, this.displayPageMax);
    }

    public int getDisplayPageIndexEnd() {
        return PagerUtil.getDisplayPageIndexEnd(this.condition, this.displayPageMax);
    }
}

