//=====================================================================
//  SYSTEM      :  DragableFloat DIV
//  PROGRAM     : ドラッグできて、スクロール時には画面の固定位置で停止するDIV
//  FILE NAME   :  jsgt_dragfloat.js
//  CALL FROM   :  HTML
//  AUTHER      :  Toshirou Takahashi http://jsgt.org/mt/01/
//  SUPPORT URL :  http://jsgt.org/mt/archives/01/000419.html
//  CREATE      :  2005.7.8
//  UPDATE      :  2005.12.13 v091 setDraging2false()を作り、div.onmouseoutへも追加。
//                            @see http://jsgt.org/lib/dragfloat/test/0/option_v08_0.htm
//  UPDATE      :  2005.11.24 v09 moveTo(x,y)を追加
//  UPDATE      :  2005.11.20 v08 セレクトができなくなるのでdocument.onmousemoveのreturn falseをコメントアウト
//  UPDATE      :  2005.9.26 v07 floatEnabled boundEnabled setBounds chkBounds追加
//  UPDATE      :  2005.9.22 v06 getTOP getLEFT getMouseX getMouseYをdivのプロパティ化
//  UPDATE      :  2005.8.12 v05ドラッグ時にieで発生するselectをonselectstartでキャンセル
//  UPDATE      :  2005.8.10 v04ドラッグ時にiframe上でイベントを拾えないのを多少修正しました
//  UPDATE      :  2005.8.8  dbg_echo()追加
//  UPDATE      :  2005.8.8  bodyタグが無い時用ダミーbody出力を追加　
//  UPDATE      :  2005.7.8 DOCTYPE 標準モードに対応
//                   参考 http://otd8.jbbs.livedoor.jp/877597/bbs_tree?base=9322&range=1
//
//
// このソースは改変も商用利用も自由ですが、
// その自由を護るために著作権は放棄しません。
//---------------------------------------------------------------------
// 高橋登史朗 (Toshirou Takahashi http://jsgt.org/mt/01/) 2005.7.8

/*
//=====================================================================
// 以下 サンプル

<-- ライブラリ  jsgt_dragfloat.js-->
<script type    = 'text/javascript'
        charset = 'UTF-8'
        src     = 'jsgt_dragfloat.js'></script>
<script type='text/javascript'>
<!--

////
// 動作開始
//
// ページ読込み時に動作開始
//
window.onload = function ()
{
    setDragableFloat() //設定
}

////
// 設定
//
// @syntax oj = dragableFloat("DIVのID名",初期位置X,初期位置Y)
//
// @sample              div1 = dragableFloat("aaa",100,200) //生成
// @sample              div1.innerHTML="あいうえお"         //HTMLを挿入
// @sample              div1.style.backgroundColor='orange' //CSSで修飾
// @sample              div1.moveTo(100,100)                //移動
// @sample              doDragableFloat()                   //開始
//    
function setDragableFloat()
{
    //ドラッガブルフロートDIVを生成
    div1 = dragableFloat("aaa",100,200)
    div2 = dragableFloat("fff",200,300)
    div3 = dragableFloat("ddd",250,300)
    
    //各DIVへHTMLを挿入
    div1.innerHTML="aaaaaaaa"
    div2.innerHTML="fffffff"
    div3.innerHTML="xx"

    //CSSで修飾
    div1.style.backgroundColor ="orange"
    div2.style.fontSize  ="18px"

    //開始
    doDragableFloat()
    
}

//-->
</script>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>



// サンプルここまで
//=====================================================================
 */
 





////
// グローバル変数
//
// @var    zcount             全ドラッガブルDIV中で現在のzindex最前面
// @var    clickElement       現在ドラッグ中のDIVのID名
// @var    canvas             document.body のDOCTYPE標準モード対応
// @array  dragableFloatId    全ドラッガブルDIVのID名を格納
//
var zcount = 0          ;
var clickElement = ""   ;
if(document.getElementsByTagName('BODY').length==0)document.write('<body>')//ダミーのbodyタグ
var canvas = document[ 'CSS1Compat' == document.compatMode ? 'documentElement' : 'body'];
var dragableFloatId=[]  ;
var recx1,recy1,recx2,recy2,recxOffset,recyOffset


////
// 設定された全ドラッガブルDIVを開始
//
//
function doDragableFloat()
{ 

  for(i in dragableFloatId){ 
    var oj = document.getElementById(dragableFloatId[i]) ;
    if(oj.floatEnabled){

      if(!(is.safari || is.khtml))
      {
        //スクロール時の動作
        window.onscroll = function(e){
            moveDiv(oj,oj.style.left,oj.style.top);
        }
      } else {
        aaa=setInterval(function(){
          moveDiv(oj,oj.style.left,oj.style.top);
        },100)
      }
    }
  }
}

//全ドラッガブルDIVのフロートをスタート
function startDragableFloat()
{
    for(i in dragableFloat ){
        var oj = document.getElementById(dragableFloat[i].id) ;
        moveDiv(oj,oj.style.left,oj.style.top);
    }
}

//DIVを浮かす    
function moveDiv (oj,ofx,ofy)
{
    if(oj.draging)return  ;//ドラッグ中は無視
    if(oj.dragcnt == 0 ){ 
        ofx = parseInt(ofx,10) 
        ofy = parseInt(ofx,10) 
        oj.dragcnt++
    } else {//ドラッグ終了位置がオフセット
        ofx = parseInt(oj.pageOffLeft,10) 
        ofy = parseInt(oj.pageOffTop,10) 
    }
    var l = parseInt(canvas.scrollLeft,10) 
    var t = parseInt(canvas.scrollTop,10) 
    oj.style.left = l + ofx+"px"
    oj.style.top  = t + ofy+"px"
}


////
//ブラウザ判定
//
// @sample               alert(is.ie)
//
var is = 
{
    ie     : !!document.all ,
    mac45  : navigator.userAgent.indexOf('MSIE 4.5; Mac_PowerPC') != -1 ,
    opera  : !!window.opera ,
    safari : navigator.userAgent.indexOf('Safari') != -1 ,
    khtml  : navigator.userAgent.indexOf('Konqueror') != -1 
}

////
// ドラッガブルフロートDIV生成
//
// @sample          div1 = dragableFloat("aaa",100,200)
//

function dragableFloat(id,x,y)
{
    if(!!dragableFloatId[id]) return document.getElementById(id)
    
    ////
    // DIV生成
    // @param  id             DIVのID名
    //
    this.mkDiv = function (id) 
    {
        var canvas = document[ 'CSS1Compat' == document.compatMode ? 'documentElement' : 'body'];
        var doc   = document                           ; // documentオブジェクト
        var body  = doc.body                           ;
        var elem  = doc.createElement("DIV")           ; //DIV要素を生成
        var div   = body.appendChild(elem);
            div.setAttribute("id",id)                   ;
            div.style.position = "absolute"           ;
            div.style.left     = x + "px"             ;
            div.style.top      = y + "px"             ;
            div.innerHTML      = ""                   ;
            div.offLeft        = 0                    ;
            div.offTop         = 0                    ;
            div.pageOffLeft    = x-parseInt(canvas.scrollLeft,10)+ "px";
            div.pageOffTop     = y-parseInt(canvas.scrollTop,10) + "px";
            div.dragcnt        = 0                    ;
            div.draging        = false                ;
            div.getTOP         = getTOP               ;
            div.getLEFT        = getLEFT              ;
            div.getMouseX      = getMouseX            ;
            div.getMouseY      = getMouseY            ;
            recx1              = x
            recy1              = y
            div.enabled        = true                 ; //DIV可能 true|false
            div.floatEnabled   = true                 ; //フロート可能 true|false
            div.boundEnabled   = false                ; //移動可能領域あり true|false
            
            div.moveTo         = function (x,y){
                div.style.left = x + "px"             ;
                div.style.top  = y + "px"             ;
            }
            div.setBounds      = function (a,b,c,d){
                div.minX=a;div.minY=b;div.maxX=c;div.maxY=d;
                div.boundEnabled = true;
            }
            div.onmouseout     = function (e){ 

                if(!clickElement) return
                selLay=document.getElementById(clickElement);
                
                //ドラッグ中止
                setDraging2false(selLay);
        
                //xyエラー時の類推追跡用xyセット
                x =  recx2+=recxOffset  
                y =  recy2+=recyOffset  
                dofollow(x,y)
                x =  recx2+=recxOffset  
                y =  recy2+=recyOffset  
                setTimeout('"dofollow('+x+','+y+')"',10)

                //follow(e)
                //dbg.innerHTML += getMouseX(e)+"--"+getMouseY(e)+"<br>"
                return false 
            }
            div.onselectstart  = function (e){ return false }
            div.onmouseover    = function (e){ return false }
            div.onmouseup      = function (e){ setDraging2false(selLay); }
            div.onmousedown    = function (e)
            {
                div.draging    = true  ;
                div.dragcnt ++         ;
                selLay=div
                clickElement = selLay.id

                //DIVのleft,topからカーソル位置までのオフセットをキャプチャ
                if (selLay){    
                    selLay.offLeft = getMouseX(e) - getLEFT(selLay.id)
                    selLay.offTop  = getMouseY(e) - getTOP(selLay.id)
                
                } 
                return false
            }

        dragableFloatId[div.id] = div.id;//windowへ登録
        div.index++;
        return div;
    }

    //マウス移動時の動作
    document.onmousemove  = function (e)
    {
        recTimeOffset(e) //rec
        follow(e)
        //return false
    }
    
    //マウスアップ時の動作
    document.onmouseup  = function (e)
    {
        if(!clickElement) return
        selLay=document.getElementById(clickElement);
        
        //ドラッグ中なのにはずれちゃった場合
        follow(e)
        
        //ドラッグ中止
        setDraging2false(selLay);

        //画面内のオフセットleft,top位置をキャプチャ
        if (selLay){
            var sl = parseInt(canvas.scrollLeft,10)
            var st = parseInt(canvas.scrollTop,10)
            selLay.pageOffLeft = getLEFT(selLay.id)-sl
            selLay.pageOffTop  = getTOP(selLay.id)-st
        }
        return false
    }

    //ドラッグ失敗時の類推追跡
    function follow(e)
    {
        if(!clickElement) return
        selLay=document.getElementById(clickElement);

        //マウス位置取得
        var x = getMouseX(e)
        var y = getMouseY(e)

        //xyエラー時の類推追跡用xyセット
        x = (x == -1)? recx2+=recxOffset : x ;
        y = (y == -1)? recy2+=recyOffset : y ;
        if(x == -1 && y == -1)setTimeout('follow('+e+')',100)

        dofollow(x,y)
    }

    //マウス追跡
    function dofollow(x,y)
    {
        if(!clickElement) return
        selLay=document.getElementById(clickElement);
        if(!chkBounds(selLay)){
          return
        } else {
          if(selLay.draging){
            //オフセットを引いて追随
            movetoX = x - selLay.offLeft
            movetoY = y - selLay.offTop
            selLay.style.left = parseInt(movetoX,10) +"px"
            selLay.style.top  = parseInt(movetoY,10) +"px"
          }
        }
       // window.status = selLay.style.left
    }

    //マウス位置を記録
    function recTimeOffset(e)
    {
        if(x == -1 || y == -1)return 
        recx2= recx1
        recy2= recy1
        recx1= getMouseX(e)
        recy1= getMouseY(e)
        recxOffset= recx1 - recx2
        recyOffset= recy1 - recy2
        
    }
    
    //指定領域内かどうかをチェック
    function chkBounds(oj){

      var layName = oj.id
      if(oj.boundEnabled){
      
        //現在位置取得
        var nowX = getLEFT(layName);
        var nowY = getTOP(layName);
        //チェック
        if( 
          nowX >= oj.minX &&
          nowY >= oj.minY &&
          nowX <= oj.maxX &&
          nowY <= oj.maxY
        ){
          return true //指定領域内ならtrue
        } else {
          returnPOS(nowX,nowY,oj)
          return false
        }
      } else {
        return true
      }
    }

    //ドラッグ中止フラグ
    function setDraging2false(selLay){
        selLay.draging   = false ;
        selLay.style.zIndex = zcount++
    }

    //領域内へ戻す
    function returnPOS(nowX,nowY,oj){
      if(nowX < oj.minX) oj.style.left = oj.minX +"px"
      if(nowY < oj.minY) oj.style.top  = oj.minY +"px"
      if(nowX > oj.maxX) oj.style.left = oj.maxX +"px"
      if(nowY > oj.maxY) oj.style.top  = oj.maxY +"px"
    }
    
    //マウスX座標get 
    function getMouseX(e)
    {
        if(document.all)               //e4,e5,e6用
            return canvas.scrollLeft+event.clientX
        else if(document.getElementById)    //n6,n7,m1,o7,s1用
            return e.pageX
    }

    //マウスY座標get 
    function getMouseY(e)
    {
        if(document.all)               //e4,e5,e6用
            return canvas.scrollTop+event.clientY
        else if(document.getElementById)    //n6,n7,m1,o7,s1用
            return e.pageY
    }


    //レイヤ－左辺X座標get 
    function getLEFT(layName){
        //デバック
        //document.getElementById('aaa').innerHTML+=layName+'<BR>'
        
        if(document.all)                    //e4,e5,e6,o6,o7用
            return document.all(layName).style.pixelLeft
        else if(document.getElementById)    //n6,n7,m1,s1用
            return (document.getElementById(layName).style.left!="")
                ?parseInt(document.getElementById(layName).style.left):""
    }

    //レイヤ－上辺Y座標get 
    function getTOP(layName){
        if(document.all)                    //e4,e5,e6,o6,o7用
            return document.all(layName).style.pixelTop
        else if(document.getElementById)    //n6,n7,m1,s1用
            return (document.getElementById(layName).style.top!="")
                    ?parseInt(document.getElementById(layName).style.top):""
    }

    //デバック
    function dbg_echo(){
            ////////dbg.innerHTML += selLay.draging+"<br>"
            
        var debugDIV  = document.createElement("DIV")  ; //DIV要素を生成
        var dbg   = document.body.appendChild(debugDIV);
            dbg.setAttribute("id","dbg")                   ;
            dbg.style.position = "absolute"           ;
            dbg.style.left     =  "400px"             ;
            dbg.style.top      = "0px"             ;
            dbg.innerHTML      = "dbg"                   ;
            return dbg;
    }  //dbg = dbg_echo()


	function db1(e)
	{
		dbg.innerHTML += getMouseX(e)+"-1000-"+getMouseY(e)+"<br>"
	}
	
	
	return this.mkDiv(id) ;
		
}
		