<?php
App::uses('AppModel', 'Model');
/**
 * TableField Model
 *
 * @property DbTable $DbTable
 */
class TableField extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'line_no' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => NUMERIC,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'symbol' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'field_type' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'db_table_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'DbTable' => array(
			'className' => 'DbTable',
			'foreignKey' => 'db_table_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

    public function newLine($db_table_id) {
		$line = $this->maxLine($db_table_id);
        return $line + 1;
    } 
    public function resetLineNo($table,$start,$end) {
        $inc = ($start > $end) ? 1:-1;
        $que = "update table_fields set line_no = line_no + ($inc) where line_no between symmetric $start and $end and db_table_id = $table";
        $this->query($que);
	}
	public function maxLine($db_table_id) {
		$que = "select max(line_no) as max_line from table_fields where db_table_id = $db_table_id";
		$res = $this->query($que);
		return $res[0][0]['max_line'];
	}
}
