<?php
App::uses('AppController', 'Controller');
/**
 * Dbs Controller
 *
 * @property Db $Db
 */
class DbsController extends AppController {

	public $components = array('eXmasCake');

/**
 * script method
 *
 * @return void
 */
	public function script($id = null) {
		$this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$db = $this->Db->read(null, $id);
		$script = $this->eXmasCake->getDbScript($db['Db']);
 		$this->set('script', $script);
		$this->set('id',$id);
	}

/**
 * constant method
 *
 * @return void
 */
	public function constant($id = null) {
		$this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$db = $this->Db->read(null, $id);
		$const = $this->getConstant($db['DbTable']);
		$this->set('const',$const);
		$this->set('id',$id);
	}
/**
 * output method
 * 
 * @return void
 */
	public function output($id = null) {
		$this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$db = $this->Db->read(null, $id);
		$path = dirname(dirname(__FILE__)).DS.'tmp'.DS.'output'.DS.'app';
		$this->eXmasCake->createFolder($path);

		if (!$this->createDbScript($path,$db)) {
            $this->Session->setFlash(SAVE_NG);
		}
		
		$this->createConst($path,$db);
		$this->createSqls($path,$db);
		$this->createModels($path,$db);
		$this->createControllers($path,$db);
		$this->createViews($path,$db);
		$this->createZip($path);
		// download
		header('Content-Type: application/zip');
		header('Content-Disposition: attachment; filename=app.zip');
		header('Content-Length: ' . filesize(dirname($path).DS.'app.zip'));
		echo file_get_contents(dirname($path).DS.'app.zip');
	}
/**
 * createDbScript method
 *
 * @return boolean
 */
	public function createDbScript($path,$db) {
		$script = $this->eXmasCake->getDbScript($db['Db']);
		file_put_contents($path.DS.'Config'.DS.'database.php',$script);
	}
/**
 * createDbScript method
 *
 * @return boolean
 */
	public function createConst($path,$db) {
		$const = $this->getConstant($db['DbTable']);
		$script = '<?php'.PHP_EOL;
		foreach ($const as $key=>$value) {
    		$script .= "const $key = '$value';".PHP_EOL;
		}
		file_put_contents($path.DS.'Config'.DS.'const.php',$script);
	}
/** 
 * createSqls method
 *
 * @return boolean
 */
	public function createSqls($path,$db) {
		$script = '';
		foreach ($db['DbTable'] as $DbTable) {
			$table = $this->Db->DbTable->read(null,$DbTable['id']);
			$script .= $this->eXmasCake->getTableSql($table);
			$script .= PHP_EOL;
		}
		file_put_contents($path.DS.'tables.sql',$script);	
	}

/** 
 * createModels method
 *
 * @return boolean
 */
	public function createModels($path,$db) {
		foreach ($db['DbTable'] as $DbTable) {
			$table = $this->Db->DbTable->read(null,$DbTable['id']);
			$names = $this->eXmasCake->getNames($table['DbTable']);
			$rules = '';
			$hasmany = '';
			$belongsto = '';

			if (!empty($table['TableField'])) {
				$names['DisplayField'] = $this->eXmasCake->getDisplayField($table['TableField']);
				$rules = $this->eXmasCake->generateRules($table['TableField']);
				$hasmanies = $this->Db->DbTable->getHasmany($table['DbTable']['symbol']);
				$hasmany = $this->eXmasCake->getHasmanies($hasmanies);
				$belongs = $this->eXmasCake->generateBelongsTo($table['TableField']);
			}
			$script = $this->eXmasCake->getModel($names,$rules,$belongs,$hasmany);
			file_put_contents($path.DS.'Model'.DS.$names['Model'].'.php',$script);
		}
	}
/**                     
 * createControllers method
 *
 * @return boolean
 */
	public function createControllers($path,$db) {
        foreach ($db['DbTable'] as $DbTable) {
			$table = $this->Db->DbTable->read(null,$DbTable['id']);
			$names = $this->eXmasCake->getNames($table['DbTable']);
			$belongs = '';
			if (!empty($table['TableField'])) {
				$belongs = $this->eXmasCake->getBelongsTo($table['TableField']);
			}
			$script = "<?php".PHP_EOL;
			$script .= "App::uses('AppController', 'Controller');".PHP_EOL;
			$script .= "/**".PHP_EOL;
			$script .= " * ".$names['ClassName']." Controller".PHP_EOL;
			$script .= " *".PHP_EOL;
			$script .= " * @property ".$names['Model']." $".$names['Model'].PHP_EOL;
			$script .= " */".PHP_EOL;
			$script .= "class ".$names['Property']."Controller extends AppController {".PHP_EOL;
			$script .= "/**".PHP_EOL;
			$script .= " * index method".PHP_EOL;
			$script .= " *".PHP_EOL;
			$script .= " * @return void".PHP_EOL;
			$script .= " */".PHP_EOL;
			$script .= $this->eXmasCake->getIndexMethod($names);
			$script .= "/**".PHP_EOL;
			$script .= " * view method".PHP_EOL;
			$script .= " *".PHP_EOL;
			$script .= " * @param string $"."id".PHP_EOL;
			$script .= " * @return void".PHP_EOL;
			$script .= " */".PHP_EOL;
			$script .= $this->eXmasCake->getViewMethod($names);
			$script .= "/**".PHP_EOL;
			$script .= " * add method".PHP_EOL;
			$script .= " *".PHP_EOL;
			$script .= " * @return void".PHP_EOL;
			$script .= " */".PHP_EOL;
			$script .= $this->eXmasCake->getAddMethod($names,$belongs);
			$script .= "/**".PHP_EOL;
			$script .= " * edit method".PHP_EOL;
			$script .= " *".PHP_EOL;
			$script .= " * @throws NotFoundException".PHP_EOL;
			$script .= " * @param string $"."id".PHP_EOL;
			$script .= " * @return void".PHP_EOL;
			$script .= " */".PHP_EOL;
			$script .= $this->eXmasCake->getEditMethod($names,$belongs);
			$script .= "/**".PHP_EOL;
			$script .= " * delete method".PHP_EOL;
			$script .= " *".PHP_EOL;
			$script .= " * @throws MethodNotAllowedException".PHP_EOL;
			$script .= " * @throws NotFoundException".PHP_EOL;
			$script .= " * @param string $"."id".PHP_EOL;
			$script .= " * @return void".PHP_EOL;
			$script .= " */".PHP_EOL;
			$script .= $this->eXmasCake->getDeleteMethod($names);
			$script .= "}".PHP_EOL;

            file_put_contents($path.DS.'Controller'.DS.$names['Property'].'Controller.php',$script);
		}
	}
/**                             
 * createControllers method
 *
 * @return boolean
 */
	public function createViews($path,$db) {
		foreach ($db['DbTable'] as $DbTable) {
			$table = $this->Db->DbTable->read(null,$DbTable['id']);

			$names = $this->eXmasCake->getNames($table['DbTable']);
			$dir = $path.DS."View".DS.$names['Property'];
			mkdir($dir);
			$this->index_view($dir,$table);
            $this->view_view($dir,$table);       
            $this->add_view($dir,$table);       
            $this->edit_view($dir,$table);
		}
	}
	function index_view($path,$table) {
		$script = $this->eXmasCake->index_view($table);
		if ($script) {
			file_put_contents($path.DS."index.ctp",$script);
		}
	}
    function view_view($path,$table) {
        $script = $this->eXmasCake->view_view($table);
        if ($script) {
        	file_put_contents($path.DS."view.ctp",$script);
		}												
	}
    function add_view($path,$table) {
        $script = $this->eXmasCake->add_view($table);
        if ($script) {
            file_put_contents($path.DS."add.ctp",$script);
        }                                               
	}
    function edit_view($path,$table) {
        $script = $this->eXmasCake->edit_view($table);
        if ($script) {
            file_put_contents($path.DS."edit.ctp",$script);
        }
	}

/**
 * createControllers method
 *
 * @return boolean
 */
	public function createZip($path) {
		$command = 'cd ' . dirname($path).'; zip -r app.zip ./app';
		exec($command);
	}

/**
 * sql method
 * 
 * @return void
 */
	public function sql($id = null) {
        $this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$db = $this->Db->read(null, $id);

		$sql = "";
		foreach ($db['DbTable'] as $dbTable) {
			$tbls = $this->Db->DbTable->read(null, $dbTable['id']);
			$sql .= $this->eXmasCake->getTableSql($tbls);
			$sql .= PHP_EOL;
		}
		$sql .= PHP_EOL;
		$this->set('script',$sql);
		$this->set('id',$id);
	}


/**
 * getConstant method
 *
 * @return $const
 */
	public function getConstant($DbTables) {
		$const = $this->eXmasCake->GeneralConst;
		foreach ($DbTables as $DbTable) {
			$key = strtoupper(Inflector::camelize($DbTable['symbol']));
			$value = $DbTable['name'];
			$const += array($key=>$value);
			$tbls = $this->Db->DbTable->read(null, $DbTable['id']);
			$Fields = $tbls['TableField'];
			foreach ($Fields as $Field) {
				$key = strtoupper($Field['symbol']);
				$value = $Field['name'];
				$const += array($key=>$value);
			}
		}
		return $const;
	}

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Db->recursive = 0;
		$this->set('dbs', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view($id = null) {
		$this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$this->set('db', $this->Db->read(null, $id));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Db->create();
			if ($this->Db->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		}
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function edit($id = null) {
		$this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Db->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		} else {
			$this->request->data = $this->Db->read(null, $id);
		}
	}

/**
 * delete method
 *
 * @throws MethodNotAllowedException
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->Db->id = $id;
		if (!$this->Db->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->Db->delete()) {
			$this->Session->setFlash(DEL_OK);
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(DEL_NG);
		$this->redirect(array('action' => 'index'));
	}

}
