#ifdef _MSC_VER
#pragma once
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <dbghelp.h>
#elif __GNUC__
#include <execinfo.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <cxxabi.h>		//f}O
#include <bfd.h>		//sԍ܂Ŏo
						//ĂȂȂ yum install binutils-devel ƂĂ!
						// #include <bfd.h> ̂RgAEgƋ@\ŜOFFɂł!!
#endif

class BackTrace
{

	//dllǂݍ݃wp[
	class LoadLibraryHelper
	{
	private:
		//DLL CX^X.
		HMODULE DllInstance;

	public:
		LoadLibraryHelper()
		{
			this->DllInstance = NULL;
		}
		virtual ~LoadLibraryHelper()
		{
			if (this->DllInstance != NULL)
			{
				::FreeLibrary(this->DllInstance);
				this->DllInstance = NULL;
			}
		}
		bool Load( const char* inDLLName )//stdǂłȂΊƂ̂߂ const char* ō.
		{
			if (this->DllInstance != NULL)
			{
				return false;
			}
			this->DllInstance = ::LoadLibraryA(inDLLName);
			return this->DllInstance != NULL;
		}
		FARPROC GetProcAddress(const char* inProcName)
		{
			if (!this->DllInstance)
			{
				return NULL;
			}
			return ::GetProcAddress(this->DllInstance,inProcName);
		}
	};

	//X^bNg[XAPI
	typedef USHORT (WINAPI *RtlCaptureStackBackTraceDef) (ULONG FramesToSkip,ULONG FramesToCapture,PVOID *BackTrace,__out_opt  PULONG BackTraceHash);
	RtlCaptureStackBackTraceDef RtlCaptureStackBackTraceProc;

	//V{GW̏łĂ邩
	bool IsSymbolEngineReady;
	//vZXnh
	HANDLE	Process;


	//AhX烂W[߂
	typedef BOOL (WINAPI *SymGetModuleInfoDef) (HANDLE hProcess, DWORD dwAddr,  PIMAGEHLP_MODULE ModuleInfo );
	SymGetModuleInfoDef SymGetModuleInfoProc;
	//AhXV{߂
	typedef BOOL (WINAPI *SymGetSymFromAddrDef) (HANDLE hProcess,DWORD Address,PDWORD Displacement,PIMAGEHLP_SYMBOL Symbol);
	SymGetSymFromAddrDef SymGetSymFromAddrProc;
	//AhXt@Cƍsԍ߂
	typedef BOOL (WINAPI *SymGetLineFromAddrDef) (HANDLE hProcess,  DWORD dwAddr,  PDWORD pdwDisplacement,  PIMAGEHLP_LINE Line);
	SymGetLineFromAddrDef SymGetLineFromAddrProc;



	//V{GW̃IvV
	typedef BOOL (WINAPI *SymSetOptionsDef) ( DWORD SymOptions );
	SymSetOptionsDef SymSetOptionsProc;

	//V{GW̏
	typedef BOOL (WINAPI *SymInitializeDef) (HANDLE hProcess,      PSTR UserSearchPath,   BOOL fInvadeProcess  );
	SymInitializeDef SymInitializeProc;

	//V{GW̏I
	typedef BOOL (WINAPI *SymCleanupDef) (HANDLE hProcess);
	SymCleanupDef SymCleanupProc;
  
	LoadLibraryHelper Kernel32Librsry;
	LoadLibraryHelper DbgHelpLibrsry;
public:
	BackTrace()
	{
		this->IsSymbolEngineReady = FALSE;
		this->RtlCaptureStackBackTraceProc = NULL;
		this->Process = NULL;
		this->SymSetOptionsProc = NULL;
		this->SymInitializeProc = NULL;
		this->SymCleanupProc = NULL;

			this->SymGetModuleInfoProc = NULL;
			this->SymGetSymFromAddrProc = NULL;
			this->SymGetLineFromAddrProc = NULL;

		if ( ! this->Kernel32Librsry.Load("kernel32.dll") )
		{
			return ;
		}
		if ( ! this->DbgHelpLibrsry.Load("dbghelp.dll") )
		{
			return ;
		}
		this->RtlCaptureStackBackTraceProc = (RtlCaptureStackBackTraceDef)this->Kernel32Librsry.GetProcAddress("RtlCaptureStackBackTrace");
			this->SymGetModuleInfoProc = (SymGetModuleInfoDef)this->DbgHelpLibrsry.GetProcAddress("SymGetModuleInfo");
			this->SymGetSymFromAddrProc = (SymGetSymFromAddrDef)this->DbgHelpLibrsry.GetProcAddress("SymGetSymFromAddr");
			this->SymGetLineFromAddrProc = (SymGetLineFromAddrDef)this->DbgHelpLibrsry.GetProcAddress("SymGetLineFromAddr");

		this->SymSetOptionsProc = (SymSetOptionsDef)this->DbgHelpLibrsry.GetProcAddress("SymSetOptions");
		this->SymInitializeProc = (SymInitializeDef)this->DbgHelpLibrsry.GetProcAddress("SymInitialize");
		this->SymCleanupProc = (SymCleanupDef)this->DbgHelpLibrsry.GetProcAddress("SymCleanup");

		if (   !this->RtlCaptureStackBackTraceProc 
			&& !this->SymSetOptionsProc
			&& !this->SymInitializeProc
			&& !this->SymCleanupProc

			&& !this->SymGetModuleInfoProc
			&& !this->SymGetSymFromAddrProc
			&& !this->SymGetLineFromAddrProc

			)
		{
			return ;
		}

		//vZXL^.
		this->Process = ::GetCurrentProcess();


		//V{GW̏.
		//sԍt̃f[^[hĂ˂Ƃ肢.
		this->SymSetOptionsProc(SYMOPT_DEFERRED_LOADS | SYMOPT_LOAD_LINES | SYMOPT_UNDNAME);
        if (this->SymInitializeProc(this->Process, NULL, TRUE))
        {
			//V{GW
			this->IsSymbolEngineReady = true;
        }

		return ;
	}
public:
	virtual ~BackTrace()
	{
		if (this->IsSymbolEngineReady)
		{
			this->SymCleanupProc(this->Process);
			this->IsSymbolEngineReady = false;
		}
	}


public:


	//X^bNg[X擾.
	int backtrace(void** buffer , int n) const
	{
		if ( ! this->RtlCaptureStackBackTraceProc )
		{
			//[hĂȂB
			return 0;
		}

		if (n >= 63)
		{
			n = 62;
		}
        return (int) this->RtlCaptureStackBackTraceProc(0,n,buffer,NULL);
	}


	//V{̉
	void addressToSymbolString(void* address ,char * outBuffer , int len) const
	{
		if ( ! this->IsSymbolEngineReady )
		{
			//V{GWłĂȂ.
			_snprintf_s(outBuffer ,len , _TRUNCATE , "0x%p @ ??? @ ??? @ ???:???" ,address );
			return ;
		}

		//W[
		IMAGEHLP_MODULE imageModule = { sizeof(IMAGEHLP_MODULE) };
		BOOL r = this->SymGetModuleInfoProc(this->Process ,(DWORD) address , &imageModule);
		if (!r)
		{
			_snprintf_s(outBuffer ,len , _TRUNCATE , "0x%p @ ??? @ ??? @ ???:???" ,address );
			return ;
		}

		//V{i[obt@.
		IMAGEHLP_SYMBOL * imageSymbol;
		char buffer[MAX_PATH + sizeof(IMAGEHLP_SYMBOL) ] = {0};
		imageSymbol = (IMAGEHLP_SYMBOL*)buffer;
		imageSymbol->SizeOfStruct = sizeof(IMAGEHLP_SYMBOL);
		imageSymbol->MaxNameLength = MAX_PATH;

		//֐̎擾...
		DWORD disp = 0;
		r = this->SymGetSymFromAddrProc(this->Process , (DWORD)address , &disp , imageSymbol );
		if (!r)
		{//֐킩܂.
			_snprintf_s(outBuffer ,len , _TRUNCATE , "0x%p @ %s @ ??? @ ???:???" ,address,imageModule.ModuleName );
			return ;
		}

		//sԍ̎擾
		IMAGEHLP_LINE line ={sizeof(IMAGEHLP_LINE)};
		r = this->SymGetLineFromAddrProc(this->Process ,(DWORD) address , &disp , &line);
		if (!r)
		{//sԍ܂
			_snprintf_s(outBuffer ,len , _TRUNCATE , "0x%p @ %s @ %s @ %s+%d" ,address,
				imageModule.ModuleName , imageSymbol->Name, imageSymbol->Name,(int) ((char*)address - (char*)line.Address) );
			return ;
		}

		//sԍ킩܂.
		_snprintf_s(outBuffer , len ,_TRUNCATE, "0x%p @ %s @ %s @ %s:%d" ,address,imageModule.ModuleName , imageSymbol->Name , line.FileName , line.LineNumber);
	}

	//V{܂Ƃ߂ĉ
	void addressToFullSymbolString(void** address ,int size , char * outBuffer , int len) const
	{
		int writesize = 0;

		int i = 0;
		for( i = 0 ; i < size ; i ++)
		{
			void * p = address[i];
			if (p == NULL)
			{
				break;
			}

			this->addressToSymbolString(p,outBuffer + writesize, len - writesize);
			writesize += (int)strlen(outBuffer + writesize);

			if (len - writesize >= 2)
			{
				strncat_s(outBuffer + writesize , len - writesize , "\r\n",2);
				writesize += 2;
			}

			if (len <= writesize)
			{
				break;
			}
		}
	}

	//obNg[X̎擾ĉʂɕ\
	void printBackTrace() const
	{
		void* stackBuffer[50];
		char symbolBuffer[1024];

		int stacksize = this->backtrace(stackBuffer , 50  );
		this->addressToFullSymbolString(stackBuffer , stacksize , symbolBuffer , 1024);

		puts(symbolBuffer);
	}

	//singleton̎擾
	static const BackTrace* Get()
	{
		static BackTrace s;
		return &s;
	}
};

class BackTraceAuto
{
	void**	StackBuffer;
	int		StackBufferSize;
public:
	BackTraceAuto()
	{
		this->StackBuffer = NULL;
		this->StackBufferSize = 0;
	}
	virtual ~BackTraceAuto()
	{
		free(this->StackBuffer);
		this->StackBuffer = NULL;
	}

	//obNg[XL^
	void recordTrace()
	{
		if (this->StackBuffer != NULL)
		{
			return ;
		}

		this->StackBuffer = (void**)malloc(sizeof(void*) * 50);
		if (this->StackBuffer == NULL)
		{
			return ;
		}
		this->StackBufferSize = BackTrace::Get()->backtrace(this->StackBuffer , 50);
	}
	//obNg[X\
	void show() const
	{
		if (this->StackBuffer == NULL)
		{
			return ;
		}

		char symbolBuffer[1024];
		BackTrace::Get()->addressToFullSymbolString(this->StackBuffer , this->StackBufferSize , symbolBuffer , 1024);

		puts(symbolBuffer);
	}
};

class my_exception
{
	BackTraceAuto	Stacktrace;
	const char * Message;
public:
	my_exception(const char * message)
	{
		//ŃX^bNۑ
		this->Stacktrace.recordTrace();
		this->Message = message;
	}
	void show() const
	{
		puts(this->Message);
		//X^bÑAhX֐ȂǂɕϊȂ\
		this->Stacktrace.show();
	}
};