/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ImageParamParser.java 201 2013-03-15 05:11:47Z kamisono_bb $
 * $Revision: 201 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.bbreak.excella.core.CellClone;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.util.ReportsUtil;

/**
 * V[g̃C[Wuϊp[T
 * 
 * @since 1.0
 */
public class ImageParamParser extends ReportsTagParser<String> {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( ImageParamParser.class);

    /**
     * JPEGt@C
     */
    private static final String JPEG_SUFFIX = ".jpeg";

    /**
     * JPGt@C
     */
    private static final String JPG_SUFFIX = ".jpg";

    /**
     * PNGt@C
     */
    private static final String PNG_SUFFIX = ".png";

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "$I";

    /**
     * uϐ̃p[^
     */
    public static final String PARAM_VALUE = "";

    /**
     * 摜̕p̃p[^
     */
    public static final String PARAM_WIDTH = "widthAdjustment";

    /**
     * 摜̍p̃p[^
     */
    public static final String PARAM_HEIGHT = "heightAdjustment";

    /**
     * 摜TCY{p̃p[^
     */
    public static final String PARAM_SCALE = "scale";

    /**
     * }IuWFNgReĩLbV
     */
    private Map<Sheet, Drawing> drawingCash = new HashMap<Sheet, Drawing>();

    /**
     * RXgN^
     */
    public ImageParamParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public ImageParamParser( String tag) {
        super( tag);
    }

    @Override
    public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

        // RgL`FbN
        if ( hasComments( sheet)) {
            throw new ParseException( "sV[g[" + sheet.getWorkbook().getSheetName( sheet.getWorkbook().getSheetIndex( sheet)) + "]FRgL");
        }

        // p[^`FbN
        checkParam( paramDef, tagCell);

        ReportsParserInfo reportsParserInfo = ( ReportsParserInfo) data;

        ParamInfo paramInfo = reportsParserInfo.getParamInfo();

        String paramValue = null;

        if ( paramInfo != null) {
            // u
            String replaceParam = paramDef.get( PARAM_VALUE);

            paramValue = getParamData( paramInfo, replaceParam);

            // 摜̕l
            Integer dx1 = null;
            if ( paramDef.containsKey( PARAM_WIDTH)) {
                dx1 = Integer.valueOf( paramDef.get( PARAM_WIDTH));
            }

            // 摜̍l
            Integer dy1 = null;
            if ( paramDef.containsKey( PARAM_HEIGHT)) {
                dy1 = Integer.valueOf( paramDef.get( PARAM_HEIGHT));
            }

            // 摜̔{
            Double scale = 1.0;
            if ( paramDef.containsKey( PARAM_SCALE)) {
                scale = Double.valueOf( paramDef.get( PARAM_SCALE));
            }

            // ZɊ܂܂邩
            if ( ReportsUtil.getMergedAddress( sheet, tagCell.getRowIndex(), tagCell.getColumnIndex()) != null) {
                CellStyle cellStyle = tagCell.getCellStyle();
                tagCell.setCellType( Cell.CELL_TYPE_BLANK);
                tagCell.setCellStyle( cellStyle);
            } else {
                tagCell = new CellClone( tagCell);
                PoiUtil.clearCell( sheet, new CellRangeAddress( tagCell.getRowIndex(), tagCell.getRowIndex(), tagCell.getColumnIndex(), tagCell.getColumnIndex()));
            }

            if ( log.isDebugEnabled()) {
                Workbook workbook = sheet.getWorkbook();
                String sheetName = workbook.getSheetName( workbook.getSheetIndex( sheet));

                log.debug( "[V[g=" + sheetName + ",Z=(" + tagCell.getRowIndex() + "," + tagCell.getColumnIndex() + ")]  " + tagCell.getStringCellValue() + "  " + paramValue);
            }

            if ( paramValue != null) {
                replaceImageValue( sheet, tagCell, paramValue, dx1, dy1, scale);
            }

        }

        // ͌ʂ̐
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        parsedReportInfo.setParsedObject( paramValue);
        parsedReportInfo.setRowIndex( tagCell.getRowIndex());
        parsedReportInfo.setColumnIndex( tagCell.getColumnIndex());
        parsedReportInfo.setDefaultRowIndex( tagCell.getRowIndex());
        parsedReportInfo.setDefaultColumnIndex( tagCell.getColumnIndex());

        return parsedReportInfo;
    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef p[^`
     * @param tagCell ^OZ
     * @throws ParseException sȃp[^ꍇ
     */
    private void checkParam( Map<String, String> paramDef, Cell tagCell) throws ParseException {
        // 摜̕ƍlȊO͕s
        if ( paramDef.containsKey( PARAM_WIDTH)) {
            try {
                Integer.parseInt( paramDef.get( PARAM_WIDTH));
            } catch ( NumberFormatException e) {
                throw new ParseException( tagCell, "ȊO̒l" + PARAM_WIDTH + ":" + paramDef.get( PARAM_WIDTH), e);
            }
        }
        if ( paramDef.containsKey( PARAM_HEIGHT)) {
            try {
                Integer.parseInt( paramDef.get( PARAM_HEIGHT));
            } catch ( NumberFormatException e) {
                throw new ParseException( tagCell, "ȊO̒l" + PARAM_HEIGHT + ":" + paramDef.get( PARAM_HEIGHT), e);
            }
        }
        // 摜̔{l͎ȊO͕s
        if ( paramDef.containsKey( PARAM_SCALE)) {
            try {
                Double.parseDouble( paramDef.get( PARAM_SCALE));
            } catch ( NumberFormatException e) {
                throw new ParseException( tagCell, "ȊO̒l" + PARAM_SCALE + ":" + paramDef.get( PARAM_SCALE), e);
            }
        }

    }

    /**
     * V[gɃRgݒ肳Ă邩擾B
     * 
     * @param sheet V[g
     * @return LFtrue^Ffalse
     */
    private boolean hasComments( Sheet sheet) {
        if ( sheet instanceof XSSFSheet) {
            XSSFSheet xssfSheet = ( XSSFSheet) sheet;
            return xssfSheet.hasComments();
        } else if ( sheet instanceof HSSFSheet) {
            Iterator<Row> rowIterator = sheet.iterator();
            while ( rowIterator.hasNext()) {
                Row row = rowIterator.next();
                Iterator<Cell> cellIterator = row.iterator();
                while ( cellIterator.hasNext()) {
                    Cell cell = cellIterator.next();
                    Comment comment = cell.getCellComment();
                    if ( comment != null) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Z̃p[^u
     * 
     * @param sheet V[g
     * @param cell ^OZ
     * @param filePath uC[Wt@CpX
     * @param dx1 摜̕l
     * @param dy1 摜̍l
     * @param scale 摜̔{l
     * @throws ParseException
     */
    public void replaceImageValue( Sheet sheet, Cell cell, String filePath, Integer dx1, Integer dy1, Double scale) throws ParseException {

        Workbook workbook = sheet.getWorkbook();

        int format = -1;
        if ( filePath.toLowerCase().endsWith( JPEG_SUFFIX) || filePath.toLowerCase().endsWith( JPG_SUFFIX)) {
            format = Workbook.PICTURE_TYPE_JPEG;
        } else if ( filePath.toLowerCase().endsWith( PNG_SUFFIX)) {
            format = Workbook.PICTURE_TYPE_PNG;
        }
        if ( format == -1) {
            throw new ParseException( cell, "Ή̉摜tH[}bgt@Cw肳Ă܂B" + filePath);
        }

        byte[] bytes = null;
        InputStream is = null;
        try {
            is = new FileInputStream( filePath);
            bytes = IOUtils.toByteArray( is);
        } catch ( Exception e) {
            throw new ParseException( cell, e);
        } finally {
            try {
                is.close();
            } catch ( IOException e) {
                throw new ParseException( cell, e);
            }
        }

        int pictureIdx = workbook.addPicture( bytes, format);

        CreationHelper helper = workbook.getCreationHelper();

        Drawing drawing = drawingCash.get( sheet);
        if ( drawing == null) {
            drawing = sheet.createDrawingPatriarch();
            drawingCash.put( sheet, drawing);
        }

        ClientAnchor anchor = helper.createClientAnchor();

        anchor.setRow1( cell.getRowIndex());
        anchor.setCol1( cell.getColumnIndex());
        anchor.setRow2( cell.getRowIndex() + 1);
        anchor.setCol2( cell.getColumnIndex() + 1);
        if ( dx1 != null) {
            anchor.setDx1( dx1);
        }
        if ( dy1 != null) {
            anchor.setDy1( dy1);
        }

        Picture picture = drawing.createPicture( anchor, pictureIdx);
        picture.resize( scale);

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.bbreak.excella.reports.tag.ReportsTagParser#useControlRow()
     */
    @Override
    public boolean useControlRow() {
        return false;
    }

}
