package org.bbreak.excella.reports.samples;

import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Map.Entry;

import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.bbreak.excella.reports.tag.BlockColRepeatParamParser;
import org.bbreak.excella.reports.tag.BlockRowRepeatParamParser;
import org.bbreak.excella.reports.tag.ColRepeatParamParser;
import org.bbreak.excella.reports.tag.SingleParamParser;

/**
 * iʔуTvo̓NX
 * 
 * @since 1.0
 */
public class ProductSalesReporter {

    private static Random random = new Random();

    /**
     * iʔуTvo͎s
     * 
     * @param args
     * @throws Exception
     */
    public static void main( String[] args) throws Exception {

        // 
        // @ǂݍރev[gt@C̃pX(gq)
        // Ao͐̃t@CpX(gqExpoterɂĎIɕt^邽߁AsvB)
        // Bt@CtH[}bg(ConvertConfiguration̔z)
        // w肵AReportBookCX^X𐶐܂B
        //
        String templateFileName = "iуev[g.xls";
        URL templateFileUrl = ProductSalesReporter.class.getResource( templateFileName);
        String templateFilePath = URLDecoder.decode( templateFileUrl.getPath(), "UTF-8");

        // TODO: o͐̃fBNgAyуt@C(gqsv)w肵ĂB
        String outputFileDir = "C:/reports_output/";
        String outputFileName1 = "i(ƕT)";
        String outputFileName2 = "i(ƕU)";
        String outputFilePath1 = outputFileDir.concat( outputFileName1);
        String outputFilePath2 = outputFileDir.concat( outputFileName2);
        ReportBook outputBook1 = new ReportBook( templateFilePath, outputFilePath1, ExcelExporter.FORMAT_TYPE);
        ReportBook outputBook2 = new ReportBook( templateFilePath, outputFilePath2, ExcelExporter.FORMAT_TYPE);

        Map<String, BigDecimal> productInfoMap = new LinkedHashMap<String, BigDecimal>();
        productInfoMap.put( "iA", new BigDecimal( 10000));
        productInfoMap.put( "iB", new BigDecimal( 9000));
        productInfoMap.put( "iC", new BigDecimal( 7000));

        // 
        // ReportSheetCX^X𐶐āAReportBookɒǉ܂B
        // 
        List<ReportSheet> outputSheets1 = createOutputSheets( productInfoMap);
        outputBook1.addReportSheets( outputSheets1);
        List<ReportSheet> outputSheets2 = createOutputSheets( productInfoMap);
        outputBook2.addReportSheets( outputSheets2);

        // 
        // ReportProcessorCX^X𐶐A
        // ReportBookɃ|[gs܂B
        // 
        ReportProcessor reportProcessor = new ReportProcessor();
        reportProcessor.process( outputBook1, outputBook2);

    }

    /**
     * ReportSheet(A2V[g)𐶐܂B
     * 
     * @return
     */
    private static List<ReportSheet> createOutputSheets( Map<String, BigDecimal> productInfoMap) {

        //
        // ev[gt@C̃V[gƏo̓V[gw肵A
        // ReportSheetCX^X𐶐܂B
        // V[gRs[AV[gύXꍇReportBook#setCopyTemplate()TRUEw肵܂B
        //
        String templateSheetName = "^";
        String outputSheetName1 = "";
        String outputSheetName2 = "";
        ReportSheet outputSheet1 = new ReportSheet( templateSheetName, outputSheetName1);
        ReportSheet outputSheet2 = new ReportSheet( templateSheetName, outputSheetName2);

        //
        // up[^ReportSheetIuWFNgɒǉ܂B
        // (ũp[^ɂ͔zn܂B)
        //
        String[] monthHeaders1 = {"4", "5", "6", "1", "7", "8", "9", "2"};
        outputSheet1.addParam( ColRepeatParamParser.DEFAULT_TAG, "Ώیwb_", monthHeaders1);
        String[] monthHeaders2 = {"10", "11", "12", "3", "1", "2", "3", "4"};
        outputSheet2.addParam( ColRepeatParamParser.DEFAULT_TAG, "Ώیwb_", monthHeaders2);

        // if[^
        List<ParamInfo> productDatas1 = new ArrayList<ParamInfo>();
        List<ParamInfo> productDatas2 = new ArrayList<ParamInfo>();
        for ( Entry<String, BigDecimal> entry : productInfoMap.entrySet()) {

            String productName = entry.getKey();
            BigDecimal unitPrice = entry.getValue();

            ParamInfo productData1 = createProductDataParamInfo( productName, unitPrice);
            productDatas1.add( productData1);
            ParamInfo productData2 = createProductDataParamInfo( productName, unitPrice);
            productDatas2.add( productData2);
        }
        outputSheet1.addParam( BlockRowRepeatParamParser.DEFAULT_TAG, "if[^", productDatas1.toArray( new ParamInfo[productDatas1.size()]));
        outputSheet2.addParam( BlockRowRepeatParamParser.DEFAULT_TAG, "if[^", productDatas2.toArray( new ParamInfo[productDatas2.size()]));

        List<ReportSheet> outputSheets = new ArrayList<ReportSheet>();
        outputSheets.add( outputSheet1);
        outputSheets.add( outputSheet2);

        return outputSheets;
    }

    /**
     * [if[^]̒up[^𐶐܂B
     * 
     * @param productName
     * @param unitPrice
     * @return
     */
    private static ParamInfo createProductDataParamInfo( String productName, BigDecimal unitPrice) {

        ParamInfo productData = new ParamInfo();

        // i
        productData.addParam( SingleParamParser.DEFAULT_TAG, "i", productName);

        // l
        List<ParamInfo> quarterlyAmounts = new ArrayList<ParamInfo>();
        ParamInfo quarterlyAmount1st = createQuarterlyAmountParamInfo( unitPrice);
        quarterlyAmounts.add( quarterlyAmount1st);
        ParamInfo quarterlyAmount2nd = createQuarterlyAmountParamInfo( unitPrice);
        quarterlyAmounts.add( quarterlyAmount2nd);
        productData.addParam( BlockColRepeatParamParser.DEFAULT_TAG, "l", quarterlyAmounts.toArray( new ParamInfo[quarterlyAmounts.size()]));

        return productData;
    }

    /**
     * [l]̒up[^𐶐܂B
     * 
     * @param unitPrice
     * @param monthFrom
     * @param monthTo
     * @return
     */
    private static ParamInfo createQuarterlyAmountParamInfo( BigDecimal unitPrice) {

        ParamInfo quarterlyAmount = new ParamInfo();

        // 
        List<ParamInfo> monthlyAmounts = new ArrayList<ParamInfo>();
        for ( int month = 1; month <= 3; month++) {
            ParamInfo monthlyAmount = createMonthlyAmountParamInfo( unitPrice);
            monthlyAmounts.add( monthlyAmount);
        }
        quarterlyAmount.addParam( BlockColRepeatParamParser.DEFAULT_TAG, "", monthlyAmounts.toArray( new ParamInfo[monthlyAmounts.size()]));

        return quarterlyAmount;
    }

    /**
     * []̒up[^𐶐܂B
     * 
     * @param unitPrice
     * @return
     */
    private static ParamInfo createMonthlyAmountParamInfo( BigDecimal unitPrice) {

        ParamInfo monthlyAmount = new ParamInfo();
        BigDecimal budget = unitPrice.multiply( new BigDecimal( random.nextInt( 5) + 5));
        BigDecimal actual = unitPrice.multiply( new BigDecimal( random.nextInt( 5) + 5));

        // \ZAсAz
        monthlyAmount.addParam( SingleParamParser.DEFAULT_TAG, "\Z", budget);
        monthlyAmount.addParam( SingleParamParser.DEFAULT_TAG, "", actual);
        monthlyAmount.addParam( SingleParamParser.DEFAULT_TAG, "z", actual.subtract( budget));

        return monthlyAmount;
    }

}
