/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.text.MessageFormat;
import org.tmatesoft.svn.core.SVNErrorCode;

public class SVNErrorMessage
implements Serializable {
    private static final long serialVersionUID = 4845L;
    public static final int TYPE_ERROR = 0;
    public static final int TYPE_WARNING = 1;
    private Object[] myObjects;
    private String myMessage;
    private SVNErrorCode myErrorCode;
    private int myType;
    private SVNErrorMessage myChildErrorMessage;
    private Throwable myThrowable;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static SVNErrorMessage UNKNOWN_ERROR_MESSAGE = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);

    public static SVNErrorMessage create(SVNErrorCode code) {
        return SVNErrorMessage.create(code, "", 0);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message) {
        return SVNErrorMessage.create(code, message, 0);
    }

    public static SVNErrorMessage create(SVNErrorCode code, Throwable cause) {
        if (cause != null) {
            return new SVNErrorMessage(code, cause.getMessage(), new Object[0], cause, 0);
        }
        return SVNErrorMessage.create(code);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message, Object object) {
        return SVNErrorMessage.create(code, message, object, 0);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message, Object[] objects) {
        return SVNErrorMessage.create(code, message, objects, 0);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message, int type) {
        return SVNErrorMessage.create(code, message, null, type, null);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message, Object object, int type) {
        Object[] objectArray;
        SVNErrorCode sVNErrorCode = code == null ? SVNErrorCode.BASE : code;
        String string = message == null ? "" : message;
        if (object == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "NULL";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = object;
        }
        return new SVNErrorMessage(sVNErrorCode, string, objectArray, null, type);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message, Object[] objects, int type) {
        return SVNErrorMessage.create(code, message, objects, type, null);
    }

    public static SVNErrorMessage create(SVNErrorCode code, String message, Object[] objects, int type, Throwable cause) {
        return new SVNErrorMessage(code == null ? SVNErrorCode.BASE : code, message == null ? "" : message, objects == null ? EMPTY_ARRAY : objects, cause, type);
    }

    protected SVNErrorMessage(SVNErrorCode code, String message, Object[] relatedObjects, Throwable th, int type) {
        this.myErrorCode = code;
        if (message != null && message.startsWith("svn: ")) {
            message = message.substring("svn: ".length());
        }
        this.myMessage = message;
        this.myObjects = relatedObjects;
        this.myType = type;
        this.myThrowable = th;
    }

    public int getType() {
        return this.myType;
    }

    public SVNErrorCode getErrorCode() {
        return this.myErrorCode;
    }

    public String getMessage() {
        return this.toString();
    }

    public String getFullMessage() {
        StringBuffer buffer = new StringBuffer();
        for (SVNErrorMessage err = this; err != null; err = err.getChildErrorMessage()) {
            buffer.append(err.getMessage());
            if (!err.hasChildErrorMessage()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String getMessageTemplate() {
        return this.myMessage;
    }

    public Object[] getRelatedObjects() {
        return this.myObjects;
    }

    public SVNErrorMessage getChildErrorMessage() {
        return this.myChildErrorMessage;
    }

    public boolean hasChildErrorMessage() {
        return this.myChildErrorMessage != null;
    }

    public Throwable getCause() {
        return this.myThrowable;
    }

    public String toString() {
        StringBuffer line = new StringBuffer();
        if (this.getType() == 1 && this.getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
            line.append("Warning: ");
        } else if (this.getType() == 1) {
            line.append("svn: warning: ");
        } else {
            line.append("svn: ");
        }
        if ("".equals(this.myMessage)) {
            line.append(this.myErrorCode.getDescription());
        } else {
            line.append(this.myObjects.length > 0 ? MessageFormat.format(this.myMessage, this.myObjects) : this.myMessage);
        }
        return line.toString();
    }

    public void setChildErrorMessage(SVNErrorMessage childMessage) {
        this.myChildErrorMessage = childMessage;
    }

    public SVNErrorMessage wrap(String parentMessage) {
        SVNErrorMessage parentError = SVNErrorMessage.create(this.getErrorCode(), parentMessage);
        parentError.setChildErrorMessage(this);
        return parentError;
    }

    public SVNErrorMessage wrap(String parentMessage, Object relatedObject) {
        SVNErrorMessage parentError = SVNErrorMessage.create(this.getErrorCode(), parentMessage, relatedObject);
        parentError.setChildErrorMessage(this);
        return parentError;
    }

    public SVNErrorMessage wrap(String parentMessage, Object[] relatedObjects) {
        SVNErrorMessage parentError = SVNErrorMessage.create(this.getErrorCode(), parentMessage, relatedObjects);
        parentError.setChildErrorMessage(this);
        return parentError;
    }

    public boolean isWarning() {
        return this.myType == 1;
    }

    public boolean setType(int type) {
        if (type == 0) {
            this.myType = 0;
            return true;
        }
        if (type == 1) {
            this.myType = 1;
            return true;
        }
        return false;
    }

    public SVNErrorMessage getRootErrorMessage() {
        SVNErrorMessage err = this;
        while (err.myChildErrorMessage != null) {
            err = err.myChildErrorMessage;
        }
        return err;
    }
}

