/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.TableRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.hssf.util.CellReference;

public final class SharedValueManager {
    public static final SharedValueManager EMPTY = new SharedValueManager(new SharedFormulaRecord[0], new ArrayRecord[0], new TableRecord[0]);
    private final ArrayRecord[] _arrayRecords;
    private final TableRecord[] _tableRecords;
    private final Map _groupsBySharedFormulaRecord;
    private SharedValueGroup[] _groups;
    private static final Comparator SVGComparator = new Comparator(){

        public int compare(Object a, Object b) {
            CellRangeAddress8Bit rangeA = ((SharedValueGroup)a).getSVR().getRange();
            CellRangeAddress8Bit rangeB = ((SharedValueGroup)b).getSVR().getRange();
            int cmp = rangeA.getFirstRow() - rangeB.getFirstRow();
            if (cmp != 0) {
                return cmp;
            }
            cmp = rangeA.getFirstColumn() - rangeB.getFirstColumn();
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }
    };

    private SharedValueManager(SharedFormulaRecord[] sharedFormulaRecords, ArrayRecord[] arrayRecords, TableRecord[] tableRecords) {
        this._arrayRecords = arrayRecords;
        this._tableRecords = tableRecords;
        HashMap<SharedFormulaRecord, SharedValueGroup> m = new HashMap<SharedFormulaRecord, SharedValueGroup>(sharedFormulaRecords.length * 3 / 2);
        for (int i = 0; i < sharedFormulaRecords.length; ++i) {
            SharedFormulaRecord sfr = sharedFormulaRecords[i];
            m.put(sfr, new SharedValueGroup(sfr));
        }
        this._groupsBySharedFormulaRecord = m;
    }

    public static SharedValueManager create(SharedFormulaRecord[] sharedFormulaRecords, ArrayRecord[] arrayRecords, TableRecord[] tableRecords) {
        if (sharedFormulaRecords.length + arrayRecords.length + tableRecords.length < 1) {
            return EMPTY;
        }
        return new SharedValueManager(sharedFormulaRecords, arrayRecords, tableRecords);
    }

    public SharedFormulaRecord linkSharedFormulaRecord(CellReference firstCell, FormulaRecordAggregate agg) {
        SharedValueGroup result = SharedValueManager.findGroup(this.getGroups(), firstCell);
        result.add(agg);
        return (SharedFormulaRecord)result.getSVR();
    }

    private static SharedValueGroup findGroup(SharedValueGroup[] groups, CellReference firstCell) {
        int row = firstCell.getRow();
        short column = firstCell.getCol();
        for (int i = 0; i < groups.length; ++i) {
            SharedValueGroup svg = groups[i];
            if (!svg.getSVR().isFirstCell(row, column)) continue;
            return svg;
        }
        SharedValueGroup result = null;
        for (int i = 0; i < groups.length; ++i) {
            SharedValueGroup svg = groups[i];
            if (!svg.getSVR().isInRange(row, column)) continue;
            if (result != null) {
                if (SharedValueManager.sharedFormulasAreSame(result, svg)) continue;
                throw new RuntimeException("This cell is in the range of more than one distinct shared formula");
            }
            result = svg;
        }
        if (result == null) {
            throw new RuntimeException("Failed to find a matching shared formula record");
        }
        return result;
    }

    private static boolean sharedFormulasAreSame(SharedValueGroup grpA, SharedValueGroup grpB) {
        SharedFormulaRecord sfrA = (SharedFormulaRecord)grpA.getSVR();
        SharedFormulaRecord sfrB = (SharedFormulaRecord)grpB.getSVR();
        return sfrA.isFormulaSame(sfrB);
    }

    private SharedValueGroup[] getGroups() {
        if (this._groups == null) {
            SharedValueGroup[] groups = new SharedValueGroup[this._groupsBySharedFormulaRecord.size()];
            this._groupsBySharedFormulaRecord.values().toArray(groups);
            Arrays.sort(groups, SVGComparator);
            this._groups = groups;
        }
        return this._groups;
    }

    public SharedValueRecordBase getRecordForFirstCell(CellReference firstCell, FormulaRecordAggregate agg) {
        boolean isTopLeft;
        int row = firstCell.getRow();
        short column = firstCell.getCol();
        boolean bl = isTopLeft = agg.getRow() == row && agg.getColumn() == column;
        if (isTopLeft) {
            int i;
            for (i = 0; i < this._tableRecords.length; ++i) {
                TableRecord tr = this._tableRecords[i];
                if (!tr.isFirstCell(row, column)) continue;
                return tr;
            }
            for (i = 0; i < this._arrayRecords.length; ++i) {
                ArrayRecord ar = this._arrayRecords[i];
                if (!ar.isFirstCell(row, column)) continue;
                return ar;
            }
        }
        SharedValueGroup[] groups = this.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            SharedValueGroup svg = groups[i];
            SharedValueRecordBase svr = svg.getSVR();
            if (!svr.isFirstCell(row, column)) continue;
            if (svg.isFirstMember(agg)) {
                return svr;
            }
            return null;
        }
        return null;
    }

    public void unlink(SharedFormulaRecord sharedFormulaRecord) {
        SharedValueGroup svg = (SharedValueGroup)this._groupsBySharedFormulaRecord.remove(sharedFormulaRecord);
        this._groups = null;
        if (svg == null) {
            throw new IllegalStateException("Failed to find formulas for shared formula");
        }
        svg.unlinkSharedFormulas();
    }

    private static final class SharedValueGroup {
        private final SharedValueRecordBase _svr;
        private FormulaRecordAggregate[] _frAggs;
        private int _numberOfFormulas;

        public SharedValueGroup(SharedValueRecordBase svr) {
            this._svr = svr;
            int width = svr.getLastColumn() - svr.getFirstColumn() + 1;
            int height = svr.getLastRow() - svr.getFirstRow() + 1;
            this._frAggs = new FormulaRecordAggregate[width * height];
            this._numberOfFormulas = 0;
        }

        public void add(FormulaRecordAggregate agg) {
            if (this._numberOfFormulas >= this._frAggs.length) {
                FormulaRecordAggregate[] temp = new FormulaRecordAggregate[this._numberOfFormulas * 2];
                System.arraycopy(this._frAggs, 0, temp, 0, this._frAggs.length);
                this._frAggs = temp;
            }
            this._frAggs[this._numberOfFormulas++] = agg;
        }

        public void unlinkSharedFormulas() {
            for (int i = 0; i < this._numberOfFormulas; ++i) {
                this._frAggs[i].unlinkSharedFormula();
            }
        }

        public SharedValueRecordBase getSVR() {
            return this._svr;
        }

        public boolean isFirstMember(FormulaRecordAggregate agg) {
            return agg == this._frAggs[0];
        }

        public final String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this._svr.getRange().toString());
            sb.append("]");
            return sb.toString();
        }
    }
}

