/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.process;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.artofsolving.jodconverter.process.ProcessManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsProcessManager
implements ProcessManager {
    private static final Pattern PROCESS_GET_LINE = Pattern.compile("^(.*?)\\s+(\\d+)\\s*$");

    @Override
    public String findPid(String regex) throws IOException {
        Pattern commandPattern = Pattern.compile(regex);
        for (String line : this.execute("wmic", "process", "get", "CommandLine,ProcessId")) {
            Matcher lineMatcher = PROCESS_GET_LINE.matcher(line);
            if (!lineMatcher.matches()) continue;
            String commandLine = lineMatcher.group(1);
            String pid = lineMatcher.group(2);
            Matcher commandMatcher = commandPattern.matcher(commandLine);
            if (!commandMatcher.find()) continue;
            return pid;
        }
        return null;
    }

    @Override
    public void kill(Process process, String pid) throws IOException {
        this.execute("taskkill", "/t", "/f", "/pid", pid);
    }

    public boolean isUsable() {
        try {
            this.execute("wmic", "quit");
            this.execute("taskkill", "/?");
            return true;
        }
        catch (IOException ioException) {
            return false;
        }
    }

    private List<String> execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        process.getOutputStream().close();
        List lines = IOUtils.readLines(process.getInputStream());
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return lines;
    }
}

